/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.utils;

import com.grokchat.GrokChatPlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MessageUtils {
    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void sendGrokResponse(Player player, String response, GrokChatPlugin plugin) {
        String prefix = MessageUtils.colorize(plugin.getConfigManager().getResponsePrefix());
        int maxLength = plugin.getConfigManager().getMaxResponseLength();
        List<String> lines = MessageUtils.splitMessage(response, maxLength);
        for (String line : lines) {
            player.sendMessage(prefix + MessageUtils.colorize(line));
        }
    }

    public static void sendGrokResponseToAll(GrokChatPlugin plugin, String response) {
        String prefix = MessageUtils.colorize(plugin.getConfigManager().getResponsePrefix());
        int maxLength = plugin.getConfigManager().getMaxResponseLength();
        List<String> lines = MessageUtils.splitMessage(response, maxLength);
        for (String line : lines) {
            plugin.getServer().broadcastMessage(prefix + MessageUtils.colorize(line));
        }
    }

    public static List<String> splitMessage(String message, int maxLength) {
        ArrayList<String> lines = new ArrayList<String>();
        if (message.length() <= maxLength) {
            lines.add(message);
            return lines;
        }
        String[] words = message.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxLength) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                }
                if (word.length() > maxLength) {
                    lines.add(word.substring(0, maxLength));
                    word = word.substring(maxLength);
                }
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static String formatError(String error) {
        return String.valueOf(ChatColor.RED) + "\u2717 " + error;
    }

    public static String formatSuccess(String message) {
        return String.valueOf(ChatColor.GREEN) + "\u2713 " + message;
    }

    public static String formatInfo(String message) {
        return String.valueOf(ChatColor.YELLOW) + "\u2139 " + message;
    }
}

