/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.utils;

import com.grokchat.GrokChatPlugin;
import com.grokchat.managers.ConfigManager;
import java.text.DecimalFormat;
import java.util.Collection;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerDataUtils {
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("#.##");

    public static String getPlayerDataContext(Player player, GrokChatPlugin plugin) {
        if (!plugin.getConfigManager().isPlayerDataEnabled()) {
            return "";
        }
        ConfigManager config = plugin.getConfigManager();
        StringBuilder context = new StringBuilder();
        context.append("Player context:\n");
        Location loc = player.getLocation();
        World world = player.getWorld();
        if (config.includePlayerPosition()) {
            context.append("- Position: ").append(COORD_FORMAT.format(loc.getX())).append(", ").append(COORD_FORMAT.format(loc.getY())).append(", ").append(COORD_FORMAT.format(loc.getZ())).append(" (Y-level: ").append((int)loc.getY()).append(")\n");
        }
        if (config.includePlayerBiome()) {
            String biomeName = world.getBiome(loc).toString().toLowerCase().replace("_", " ");
            context.append("- Biome: ").append(biomeName).append("\n");
        }
        if (config.includePlayerWorld()) {
            String worldName = world.getEnvironment().toString();
            String worldDisplayName = PlayerDataUtils.formatWorldName(worldName);
            context.append("- Dimension: ").append(worldDisplayName).append("\n");
        }
        if (config.includePlayerHealth()) {
            double health = player.getHealth();
            double maxHealth = player.getMaxHealth();
            int foodLevel = player.getFoodLevel();
            double saturation = player.getSaturation();
            context.append("- Health: ").append(PlayerDataUtils.formatHealth(health)).append("/").append(PlayerDataUtils.formatHealth(maxHealth)).append(" hearts\n");
            context.append("- Hunger: ").append(foodLevel).append("/20");
            if (saturation > 0.0) {
                context.append(" (saturation: ").append(COORD_FORMAT.format(saturation)).append(")");
            }
            context.append("\n");
        }
        if (config.includePlayerExperience()) {
            int level = player.getLevel();
            float expProgress = player.getExp();
            int totalExp = player.getTotalExperience();
            context.append("- Experience: Level ").append(level).append(" (").append(COORD_FORMAT.format(expProgress * 100.0f)).append("% to next level)");
            if (totalExp > 0) {
                context.append(", Total XP: ").append(totalExp);
            }
            context.append("\n");
        }
        if (config.includePlayerHeldItem()) {
            int selectedSlot;
            ItemStack hotbarItem;
            int percent;
            short maxDurability;
            int durability;
            boolean hasOffHand;
            PlayerInventory inv = player.getInventory();
            ItemStack mainHand = inv.getItemInMainHand();
            ItemStack offHand = inv.getItemInOffHand();
            boolean hasMainHand = mainHand != null && !mainHand.getType().isAir() && mainHand.getAmount() > 0;
            boolean bl = hasOffHand = offHand != null && !offHand.getType().isAir() && offHand.getAmount() > 0;
            if (config.isDebug()) {
                plugin.getLogger().info("[PlayerData] Player: " + player.getName() + ", Main Hand: " + (mainHand != null ? mainHand.getType().toString() : "null") + ", Off Hand: " + (offHand != null ? offHand.getType().toString() : "null") + ", Selected Slot: " + inv.getHeldItemSlot());
            }
            if (hasMainHand) {
                String itemName = PlayerDataUtils.formatItemName(mainHand);
                context.append("- Held Item (Main Hand): ").append(itemName);
                if (mainHand.getType().getMaxDurability() > 0) {
                    durability = mainHand.getType().getMaxDurability() - mainHand.getDurability();
                    maxDurability = mainHand.getType().getMaxDurability();
                    percent = (int)((double)durability / (double)maxDurability * 100.0);
                    context.append(" (Durability: ").append(percent).append("%)");
                }
                if (mainHand.getAmount() > 1 && mainHand.getType().getMaxStackSize() > 1) {
                    context.append(" x").append(mainHand.getAmount());
                }
                context.append("\n");
            }
            if (hasOffHand) {
                String itemName = PlayerDataUtils.formatItemName(offHand);
                context.append("- Held Item (Off Hand): ").append(itemName);
                if (offHand.getType().getMaxDurability() > 0) {
                    durability = offHand.getType().getMaxDurability() - offHand.getDurability();
                    maxDurability = offHand.getType().getMaxDurability();
                    percent = (int)((double)durability / (double)maxDurability * 100.0);
                    context.append(" (Durability: ").append(percent).append("%)");
                }
                if (offHand.getAmount() > 1 && offHand.getType().getMaxStackSize() > 1) {
                    context.append(" x").append(offHand.getAmount());
                }
                context.append("\n");
            }
            if (!(hasMainHand || hasOffHand || (hotbarItem = inv.getItem(selectedSlot = inv.getHeldItemSlot())) == null || hotbarItem.getType().isAir() || hotbarItem.getAmount() <= 0)) {
                String itemName = PlayerDataUtils.formatItemName(hotbarItem);
                context.append("- Selected Item (Hotbar Slot ").append(selectedSlot + 1).append("): ").append(itemName);
                if (hotbarItem.getType().getMaxDurability() > 0) {
                    int durability2 = hotbarItem.getType().getMaxDurability() - hotbarItem.getDurability();
                    short maxDurability2 = hotbarItem.getType().getMaxDurability();
                    int percent2 = (int)((double)durability2 / (double)maxDurability2 * 100.0);
                    context.append(" (Durability: ").append(percent2).append("%)");
                }
                if (hotbarItem.getAmount() > 1 && hotbarItem.getType().getMaxStackSize() > 1) {
                    context.append(" x").append(hotbarItem.getAmount());
                }
                context.append("\n");
            }
        }
        if (config.includePlayerEquipment()) {
            PlayerInventory inv = player.getInventory();
            ItemStack helmet = inv.getHelmet();
            ItemStack chestplate = inv.getChestplate();
            ItemStack leggings = inv.getLeggings();
            ItemStack boots = inv.getBoots();
            boolean hasEquipment = false;
            if (helmet != null && !helmet.getType().isAir()) {
                context.append("- Equipment: Helmet: ").append(PlayerDataUtils.formatItemName(helmet));
                hasEquipment = true;
            }
            if (chestplate != null && !chestplate.getType().isAir()) {
                if (hasEquipment) {
                    context.append(", ");
                } else {
                    context.append("- Equipment: ");
                }
                context.append("Chestplate: ").append(PlayerDataUtils.formatItemName(chestplate));
                hasEquipment = true;
            }
            if (leggings != null && !leggings.getType().isAir()) {
                if (hasEquipment) {
                    context.append(", ");
                } else {
                    context.append("- Equipment: ");
                }
                context.append("Leggings: ").append(PlayerDataUtils.formatItemName(leggings));
                hasEquipment = true;
            }
            if (boots != null && !boots.getType().isAir()) {
                if (hasEquipment) {
                    context.append(", ");
                } else {
                    context.append("- Equipment: ");
                }
                context.append("Boots: ").append(PlayerDataUtils.formatItemName(boots));
                hasEquipment = true;
            }
            if (hasEquipment) {
                context.append("\n");
            }
        }
        if (config.includePlayerGamemode()) {
            GameMode gameMode = player.getGameMode();
            context.append("- Game Mode: ").append(PlayerDataUtils.formatGameMode(gameMode)).append("\n");
        }
        if (config.includePlayerEffects()) {
            boolean isOnFire;
            Collection effects = player.getActivePotionEffects();
            boolean bl = isOnFire = player.getFireTicks() > 0;
            if (!effects.isEmpty() || isOnFire) {
                context.append("- Status Effects: ");
                boolean first = true;
                if (isOnFire) {
                    int fireTicks = player.getFireTicks() / 20;
                    context.append("On Fire (").append(fireTicks).append("s)");
                    first = false;
                }
                for (PotionEffect effect : effects) {
                    if (!first) {
                        context.append(", ");
                    }
                    String effectName = PlayerDataUtils.formatEffectName(effect.getType());
                    int amplifier = effect.getAmplifier();
                    int duration = effect.getDuration() / 20;
                    context.append(effectName);
                    if (amplifier > 0) {
                        context.append(" ").append(amplifier + 1);
                    }
                    context.append(" (").append(PlayerDataUtils.formatDuration(duration)).append(")");
                    first = false;
                }
                context.append("\n");
            }
        }
        return context.toString();
    }

    private static String formatHealth(double health) {
        return COORD_FORMAT.format(health / 2.0);
    }

    private static String formatWorldName(String worldName) {
        switch (worldName.toUpperCase()) {
            case "NORMAL": {
                return "Overworld";
            }
            case "NETHER": {
                return "Nether";
            }
            case "THE_END": {
                return "End";
            }
        }
        return worldName;
    }

    private static String formatItemName(ItemStack item) {
        String materialName;
        if (item == null) {
            return "Unknown Item";
        }
        if (item.hasItemMeta()) {
            try {
                ItemMeta meta = item.getItemMeta();
                if (meta != null && meta.hasDisplayName()) {
                    return meta.getDisplayName();
                }
            }
            catch (Exception meta) {
                // empty catch block
            }
        }
        if ((materialName = item.getType().toString().toLowerCase()).equals("air") || materialName.equals("legacy_air")) {
            return "Empty";
        }
        materialName = materialName.replace("_", " ");
        String[] words = materialName.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(word.substring(0, 1).toUpperCase());
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }

    private static String formatGameMode(GameMode gameMode) {
        switch (gameMode) {
            case SURVIVAL: {
                return "Survival";
            }
            case CREATIVE: {
                return "Creative";
            }
            case ADVENTURE: {
                return "Adventure";
            }
            case SPECTATOR: {
                return "Spectator";
            }
        }
        return gameMode.toString();
    }

    private static String formatEffectName(PotionEffectType effectType) {
        String name = effectType.getName().toLowerCase().replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return result.toString();
    }

    private static String formatDuration(int seconds) {
        if (seconds < 60) {
            return seconds + "s";
        }
        if (seconds < 3600) {
            int minutes = seconds / 60;
            int remainingSeconds = seconds % 60;
            if (remainingSeconds == 0) {
                return minutes + "m";
            }
            return minutes + "m " + remainingSeconds + "s";
        }
        int hours = seconds / 3600;
        int remainingMinutes = seconds % 3600 / 60;
        if (remainingMinutes == 0) {
            return hours + "h";
        }
        return hours + "h " + remainingMinutes + "m";
    }
}

