/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public final class AdaptiveUpdateScheduler<ID> {
    private final Map<ID, Entry> entries = new ConcurrentHashMap<ID, Entry>();
    private volatile double baseUpdateRatePerTick;
    private final double minUpdateRatePerTick;
    private final double updateTimeTargetMs;
    private final double updateTimeSmoothingTimeWindowMs;
    public volatile double smoothedAverageUpdateTimeMs = 0.0;
    private long thisFrameAccumulatedUpdateTimeNano = 0L;
    private final double scaleSmoothingTimeConstantMs;
    private final double maxScaleChangePerFrame;
    private double smoothedBudgetScale = 1.0;
    private final boolean useFpsGuard;
    private final double fpsGuardTargetFrameMs;
    private final double fpsEmaAlpha;
    private volatile double smoothedAverageFrameTimeMs;
    private final double minFpsScale;
    private static final double GOLDEN_EPS = 9.765625E-8;
    private long currentTick = Long.MIN_VALUE;
    private final int evictAfterTicks;

    private AdaptiveUpdateScheduler(double baseRatePerTick, double minRatePerTick, double targetBudgetMs, double smoothingTimeConstantMs, double scaleSmoothingTimeConstantMs, double maxScaleChangePerFrame, boolean useFpsGuard, double fpsGuardTargetFrameMs, double fpsEmaAlpha, double minFpsScale, int evictAfterTicks) {
        this.baseUpdateRatePerTick = AdaptiveUpdateScheduler.requirePos(baseRatePerTick, "baseRatePerTick");
        this.minUpdateRatePerTick = AdaptiveUpdateScheduler.requirePos(minRatePerTick, "minRatePerTick");
        this.updateTimeTargetMs = AdaptiveUpdateScheduler.requirePos(targetBudgetMs, "targetBudgetMs");
        this.updateTimeSmoothingTimeWindowMs = AdaptiveUpdateScheduler.requirePos(smoothingTimeConstantMs, "smoothingTimeConstantMs");
        this.scaleSmoothingTimeConstantMs = AdaptiveUpdateScheduler.requirePos(scaleSmoothingTimeConstantMs, "scaleSmoothingTimeConstantMs");
        this.maxScaleChangePerFrame = AdaptiveUpdateScheduler.requirePos(maxScaleChangePerFrame, "maxScaleChangePerFrame");
        this.useFpsGuard = useFpsGuard;
        this.fpsGuardTargetFrameMs = useFpsGuard ? AdaptiveUpdateScheduler.requirePos(fpsGuardTargetFrameMs, "fpsGuardTargetFrameMs") : 16.667;
        this.fpsEmaAlpha = AdaptiveUpdateScheduler.requireAlpha(fpsEmaAlpha, "fpsEmaAlpha");
        this.minFpsScale = AdaptiveUpdateScheduler.requireAlpha(minFpsScale, "minFpsScale");
        this.smoothedAverageFrameTimeMs = this.fpsGuardTargetFrameMs;
        if (evictAfterTicks < 1) {
            throw new IllegalArgumentException("evictAfterTicks must be >= 1");
        }
        this.evictAfterTicks = evictAfterTicks;
    }

    private static double requirePos(double v, String name) {
        if (v <= 0.0) {
            throw new IllegalArgumentException(name + " must be > 0");
        }
        return v;
    }

    private static double requireAlpha(double v, String name) {
        if (v <= 0.0 || v > 1.0) {
            throw new IllegalArgumentException(name + " must be in (0,1]");
        }
        return v;
    }

    public double getAverageUpdateTimeMs() {
        return this.smoothedAverageUpdateTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryRunUpdate(ID id, Runnable update) {
        long tick = class_310.method_1551().field_1687.method_8510();
        this.onNewTick(tick);
        Entry e = this.entries.computeIfAbsent(id, j -> new Entry(this, id, tick));
        e.lastTickSeen = tick;
        if (this.stepPhaseAndGrant(e)) {
            long t0 = System.nanoTime();
            try {
                update.run();
            }
            finally {
                this.thisFrameAccumulatedUpdateTimeNano += System.nanoTime() - t0;
            }
        }
    }

    public void runIfShouldUpdate(ID id, Runnable update) {
        this.tryRunUpdate(id, update);
    }

    public void forceUpdateNextTick(ID id) {
        long tick = class_310.method_1551().field_1687.method_8510();
        Entry e = this.entries.computeIfAbsent(id, j -> new Entry(this, id, tick));
        e.lastTickSeen = tick;
        e.lastTickTouched = tick;
        e.phase01 = Math.nextAfter(1.0, Double.NEGATIVE_INFINITY);
    }

    public void onEndOfFrame() {
        double lastFrameMs = Math.max(0.001, (double)class_310.method_1551().method_47600() / 1000000.0);
        double updateMsThisFrame = (double)this.thisFrameAccumulatedUpdateTimeNano / 1000000.0;
        double alphaTime = 1.0 - Math.exp(-lastFrameMs / this.updateTimeSmoothingTimeWindowMs);
        this.smoothedAverageUpdateTimeMs = (1.0 - alphaTime) * this.smoothedAverageUpdateTimeMs + alphaTime * updateMsThisFrame;
        this.thisFrameAccumulatedUpdateTimeNano = 0L;
        double rawScale = this.updateTimeTargetMs <= 0.0 || this.smoothedAverageUpdateTimeMs <= 0.0 ? 1.0 : class_3532.method_15350((double)(this.updateTimeTargetMs / this.smoothedAverageUpdateTimeMs), (double)0.0, (double)1.0);
        double betaScale = 1.0 - Math.exp(-lastFrameMs / this.scaleSmoothingTimeConstantMs);
        double targetScale = (1.0 - betaScale) * this.smoothedBudgetScale + betaScale * rawScale;
        double delta = class_3532.method_15350((double)(targetScale - this.smoothedBudgetScale), (double)(-this.maxScaleChangePerFrame), (double)this.maxScaleChangePerFrame);
        this.smoothedBudgetScale += delta;
        if (this.useFpsGuard) {
            this.smoothedAverageFrameTimeMs = (1.0 - this.fpsEmaAlpha) * this.smoothedAverageFrameTimeMs + this.fpsEmaAlpha * lastFrameMs;
        }
    }

    public void setBaseRatePerTick(double v) {
        this.baseUpdateRatePerTick = AdaptiveUpdateScheduler.requirePos(v, "baseRatePerTick");
    }

    private void onNewTick(long tick) {
        if (tick != this.currentTick) {
            if (this.currentTick != Long.MIN_VALUE && (tick & 0xFFL) == 0L) {
                this.evictStale(tick);
            }
            this.currentTick = tick;
        }
    }

    private void evictStale(long tick) {
        long cutoff = tick - (long)this.evictAfterTicks;
        this.entries.entrySet().removeIf(en -> ((Entry)en.getValue()).lastTickSeen < cutoff);
    }

    private boolean stepPhaseAndGrant(Entry e) {
        boolean granted;
        double effRate = this.computeEffectiveUpdateRate();
        double step = (effRate = class_3532.method_15350((double)effRate, (double)0.0, (double)1.0)) + 9.765625E-8;
        double newPhase = e.phase01 + step;
        boolean bl = granted = newPhase >= 1.0;
        if (granted) {
            newPhase -= 1.0;
        }
        e.phase01 = newPhase;
        e.lastTickTouched = this.currentTick;
        return granted;
    }

    private double computeEffectiveUpdateRate() {
        double scaled = Math.max(this.minUpdateRatePerTick, this.baseUpdateRatePerTick * this.smoothedBudgetScale);
        if (this.useFpsGuard) {
            double fpsScale = class_3532.method_15350((double)(this.fpsGuardTargetFrameMs / Math.max(this.smoothedAverageFrameTimeMs, this.fpsGuardTargetFrameMs)), (double)0.0, (double)1.0);
            fpsScale = Math.max(this.minFpsScale, fpsScale);
            scaled = Math.max(this.minUpdateRatePerTick, scaled * fpsScale);
        }
        return scaled;
    }

    private static double stablePhaseFromId(Object id) {
        int x = id == null ? 0 : id.hashCode();
        long z = AdaptiveUpdateScheduler.mix64(x);
        long mant = z >>> 11;
        return (double)mant * (double)1.110223E-16f;
    }

    private static long mix64(int x) {
        long z = (long)x * 2654435769L ^ 0xBF58476D1CE4E5B9L;
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class Entry {
        double phase01;
        long lastTickSeen;
        long lastTickTouched;

        Entry(AdaptiveUpdateScheduler adaptiveUpdateScheduler, ID id, long tick) {
            this.phase01 = AdaptiveUpdateScheduler.stablePhaseFromId(id);
            this.lastTickSeen = tick;
            this.lastTickTouched = tick;
        }
    }

    public static final class Builder {
        private double baseRatePerTick;
        private double minRatePerTick;
        private double updateTimeTargetMs = 5.0;
        private double updateTimeSmoothingTimeWindowMs = 300.0;
        private double scaleSmoothingTimeWindowMs = 350.0;
        private double maxScaleChangePerFrame = 0.08;
        private boolean useFpsGuard = false;
        private double fpsGuardTargetFrameMs = 16.667;
        private double fpsEmaAlpha = 0.2;
        private double minFpsScale = 0.2;
        private int evictAfterTicks = 100;

        public Builder baseRatePerTick(double v) {
            if (v <= 0.0) {
                throw new IllegalArgumentException("baseRatePerTick must be > 0");
            }
            this.baseRatePerTick = v;
            return this;
        }

        public Builder basePeriodTicks(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("ticks must be > 0");
            }
            return this.baseRatePerTick(1.0 / (double)ticks);
        }

        public Builder baseFps(double fps) {
            if (fps <= 0.0) {
                throw new IllegalArgumentException("fps must be > 0");
            }
            return this.baseRatePerTick(fps / 20.0);
        }

        public Builder minRatePerTick(double v) {
            if (v <= 0.0) {
                throw new IllegalArgumentException("minRatePerTick must be > 0");
            }
            this.minRatePerTick = v;
            return this;
        }

        public Builder minPeriodTicks(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("ticks must be > 0");
            }
            return this.minRatePerTick(1.0 / (double)ticks);
        }

        public Builder minFps(double fps) {
            if (fps <= 0.0) {
                throw new IllegalArgumentException("fps must be > 0");
            }
            return this.minRatePerTick(fps / 20.0);
        }

        public Builder targetBudgetMs(double v) {
            if (v <= 0.0) {
                throw new IllegalArgumentException("targetBudgetMs must be > 0");
            }
            this.updateTimeTargetMs = v;
            return this;
        }

        public Builder targetBudgetFromFps(double fps, double share) {
            if (fps <= 0.0) {
                throw new IllegalArgumentException("fps must be > 0");
            }
            if (share <= 0.0 || share > 1.0) {
                throw new IllegalArgumentException("share must be in (0,1]");
            }
            return this.targetBudgetMs(1000.0 / fps * share);
        }

        public Builder smoothingTimeConstantMs(double v) {
            if (v <= 0.0) {
                throw new IllegalArgumentException("smoothingTimeConstantMs must be > 0");
            }
            this.updateTimeSmoothingTimeWindowMs = v;
            return this;
        }

        public Builder scaleSmoothingTimeConstantMs(double v) {
            if (v <= 0.0) {
                throw new IllegalArgumentException("scaleSmoothingTimeConstantMs must be > 0");
            }
            this.scaleSmoothingTimeWindowMs = v;
            return this;
        }

        public Builder maxScaleChangePerFrame(double v) {
            if (v <= 0.0 || v > 1.0) {
                throw new IllegalArgumentException("maxScaleChangePerFrame must be in (0,1]");
            }
            this.maxScaleChangePerFrame = v;
            return this;
        }

        public Builder guardTargetFps(double fps) {
            if (fps <= 0.0) {
                throw new IllegalArgumentException("fps must be > 0");
            }
            this.fpsGuardTargetFrameMs = 1000.0 / fps;
            this.useFpsGuard = true;
            return this;
        }

        public Builder fpsGuardAlpha(double alpha) {
            if (alpha <= 0.0 || alpha > 1.0) {
                throw new IllegalArgumentException("fpsEmaAlpha must be in (0,1]");
            }
            this.fpsEmaAlpha = alpha;
            return this;
        }

        public Builder minFpsScale(double v) {
            if (v <= 0.0 || v > 1.0) {
                throw new IllegalArgumentException("minFpsScale must be in (0,1]");
            }
            this.minFpsScale = v;
            return this;
        }

        public Builder evictAfterTicks(int v) {
            if (v < 1) {
                throw new IllegalArgumentException("evictAfterTicks must be >= 1");
            }
            this.evictAfterTicks = v;
            return this;
        }

        public <T> AdaptiveUpdateScheduler<T> build() {
            return new AdaptiveUpdateScheduler(this.baseRatePerTick, this.minRatePerTick, this.updateTimeTargetMs, this.updateTimeSmoothingTimeWindowMs, this.scaleSmoothingTimeWindowMs, this.maxScaleChangePerFrame, this.useFpsGuard, this.fpsGuardTargetFrameMs, this.fpsEmaAlpha, this.minFpsScale, this.evictAfterTicks);
        }
    }
}

