/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import net.mehvahdjukaar.vista.common.ViewFinderAccess;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5250;
import net.minecraft.class_5498;
import net.minecraft.class_6880;
import net.minecraft.class_744;
import net.minecraft.class_746;

public class ViewFinderController {
    protected static ViewFinderAccess access;
    private static class_5498 lastCameraType;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    private static float lastCameraYaw;
    private static float lastCameraPitch;

    public static void startControlling(ViewFinderAccess cannonAccess) {
        class_310 mc = class_310.method_1551();
        if (access == null) {
            access = cannonAccess;
            lastCameraType = mc.field_1690.method_31044();
        }
        mc.field_1690.method_31043(class_5498.field_26665);
        class_5250 message = class_2561.method_43469((String)"message.vista.viewfinder.control", (Object[])new Object[]{mc.field_1690.field_1832.method_16007(), mc.field_1690.field_1886.method_16007()});
        mc.field_1705.method_1758((class_2561)message, false);
        mc.method_44713().method_37015((class_2561)message);
        class_4184 camera = mc.field_1773.method_19418();
        ViewFinderBlockEntity tile = access.getInternalTile();
        camera.method_19325(class_3532.method_15393((float)tile.getYaw()), class_3532.method_15393((float)tile.getPitch()));
    }

    private static void stopControllingAndSync() {
        if (access == null) {
            return;
        }
        access.syncToServer(true);
        ViewFinderController.stopControlling();
    }

    public static void stopControlling() {
        if (access == null) {
            return;
        }
        access = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        if (lastCameraType != null) {
            class_310.method_1551().field_1690.method_31043(lastCameraType);
        }
    }

    public static boolean isActive() {
        return access != null;
    }

    public static boolean isLocked() {
        return access.getInternalTile().isLocked();
    }

    public static boolean setupCamera(class_4184 camera, class_1922 level, class_1297 entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        class_243 centerCannonPos = access.getCannonGlobalPosition(partialTick);
        class_243 targetCameraPos = centerCannonPos.method_1031(0.0, 0.5, 0.0);
        float targetYRot = camera.method_19330() + yawIncrease;
        float targetXRot = class_3532.method_15363((float)(camera.method_19329() + pitchIncrease), (float)-90.0f, (float)90.0f);
        camera.method_19322(targetCameraPos);
        camera.method_19325(targetYRot, targetXRot);
        lastCameraYaw = camera.method_19330();
        lastCameraPitch = camera.method_19329();
        yawIncrease = 0.0f;
        pitchIncrease = 0.0f;
        float followSpeed = 1.0f;
        ViewFinderBlockEntity tile = access.getInternalTile();
        tile.setPitch(access, class_3532.method_17821((float)followSpeed, (float)tile.getPitch(), (float)lastCameraPitch));
        tile.setRenderYaw(access, lastCameraYaw + access.getCannonGlobalYawOffset(partialTick));
        return true;
    }

    public static boolean onPlayerRotated(double yawAdd, double pitchAdd) {
        if (ViewFinderController.isActive()) {
            if (ViewFinderController.isLocked()) {
                return true;
            }
            float scale = 0.2f * (1.0f - access.getInternalTile().getNormalizedZoomFactor() + 0.01f);
            yawIncrease += (float)(yawAdd * (double)scale);
            pitchIncrease += (float)(pitchAdd * (double)scale);
            if (yawAdd != 0.0 || pitchAdd != 0.0) {
                needsToUpdateServer = true;
            }
            if (access.shouldRotatePlayerFaceWhenManeuvering()) {
                class_746 player = class_310.method_1551().field_1724;
                player.method_5872(class_3532.method_15338((double)((double)lastCameraYaw + yawAdd - (double)player.field_6241)), class_3532.method_15338((double)((double)lastCameraPitch + pitchAdd - (double)player.method_36455())));
                player.field_6259 = player.field_6241;
                player.field_6004 = player.method_36455();
            }
            return true;
        }
        return false;
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        int oldZoom;
        ViewFinderBlockEntity tile;
        int newZoom;
        if (!ViewFinderController.isActive()) {
            return false;
        }
        if (ViewFinderController.isLocked()) {
            return true;
        }
        if (scrollDelta != 0.0 && (newZoom = Math.clamp((long)((int)((double)(tile = access.getInternalTile()).getZoomLevel() + scrollDelta)), 1, tile.getMaxZoom())) != (oldZoom = tile.getZoomLevel())) {
            tile.setZoomLevel(newZoom);
            needsToUpdateServer = true;
            if (newZoom % 4 == 0) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)3.0f));
            }
        }
        return true;
    }

    public static boolean onPlayerAttack() {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        ViewFinderController.toggleLock();
        return true;
    }

    public static boolean onPlayerUse() {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        ViewFinderController.toggleLock();
        return true;
    }

    private static void toggleLock() {
        ViewFinderBlockEntity tile;
        tile.setLocked(!(tile = access.getInternalTile()).isLocked());
        needsToUpdateServer = true;
    }

    public static void onInputUpdate(class_744 input) {
        if (access.impedePlayerMovementWhenManeuvering()) {
            input.field_3909 = false;
            input.field_3910 = false;
            input.field_3908 = false;
            input.field_3906 = false;
            input.field_3905 = 0.0f;
            input.field_3907 = 0.0f;
        }
        input.field_3903 = false;
        input.field_3904 = false;
    }

    public static void onClientTick(class_310 mc) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!ViewFinderController.isActive()) {
            return;
        }
        if (access.stillValid((class_1657)player)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                access.syncToServer(false);
            }
        } else {
            ViewFinderController.stopControllingAndSync();
        }
    }

    public static boolean onEarlyKeyPress(int key, int scanCode, int action, int modifiers) {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        class_315 options = class_310.method_1551().field_1690;
        if (key == 256) {
            ViewFinderController.stopControllingAndSync();
            return true;
        }
        if (options.field_1822.method_1417(key, scanCode)) {
            return true;
        }
        if (options.field_1903.method_1417(key, scanCode)) {
            return true;
        }
        if (options.field_1832.method_1417(key, scanCode)) {
            ViewFinderController.stopControllingAndSync();
            return true;
        }
        return false;
    }

    public static boolean isZooming() {
        if (ViewFinderController.isActive()) {
            ViewFinderBlockEntity tile = access.getInternalTile();
            return tile.getZoomLevel() > 1;
        }
        return false;
    }

    public static float modifyFOV(float start, float modified, class_1657 player) {
        if (ViewFinderController.isActive()) {
            return access.getInternalTile().getModifiedFOV(start, modified);
        }
        return modified;
    }

    static {
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
    }
}

