/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.common.TVBlock;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class TVBlockEntity
extends ItemDisplayTile {
    @Nullable
    private UUID linkedFeedUuid = null;
    @Nullable
    private class_6880<CassetteTape> tape = null;
    private int connectedTvsSize = 1;
    private int soundLoopTicks = 0;
    private int animationTicks = 0;

    public TVBlockEntity(class_2338 pos, class_2680 state) {
        super(VistaMod.TV_TILE.get(), pos, state);
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        compound.method_10569("ConnectedTVsSize", this.connectedTvsSize);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.connectedTvsSize = tag.method_10550("ConnectedTVsSize");
    }

    @Nullable
    public UUID getLinkedFeedUUID() {
        return this.linkedFeedUuid;
    }

    @Nullable
    public class_6880<CassetteTape> getTape() {
        return this.tape;
    }

    public int getScreenPixelSize() {
        return 12;
    }

    public class_3414 getAddItemSound() {
        return VistaMod.CASSETTE_INSERT_SOUND.get();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"tv");
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return true;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return stack.method_31574((class_1792)VistaMod.CASSETTE.get()) || stack.method_31574((class_1792)VistaMod.HOLLOW_CASSETTE.get()) || VistaMod.EXPOSURE_ON && ExposureCompat.isPictureItem(stack);
    }

    private void cacheClientState() {
        class_1799 displayedItem = this.getDisplayedItem();
        this.linkedFeedUuid = (UUID)displayedItem.method_57824(VistaMod.LINKED_FEED_COMPONENT.get());
        this.tape = (class_6880)displayedItem.method_57824(VistaMod.CASSETTE_TAPE_COMPONENT.get());
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.cacheClientState();
    }

    public class_9062 interactWithPlayerItem(class_1657 player, class_1268 handIn, class_1799 stack, int slot) {
        class_1799 current = this.getDisplayedItem();
        if (!current.method_7960()) {
            this.field_11863.method_8396(player, this.field_11867, VistaMod.CASSETTE_EJECT_SOUND.get(), class_3419.field_15245, 1.0f, 1.0f);
            class_243 vec3 = this.field_11863.method_8320(this.field_11867.method_10084()).method_51367() ? this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)TVBlock.field_11177)).method_46558() : class_243.method_49273((class_2382)this.field_11867, (double)0.5, (double)1.05, (double)0.5);
            vec3 = vec3.method_49272(this.field_11863.field_9229, 0.7f);
            class_1799 itemStack2 = current.method_7972();
            class_1542 itemEntity = new class_1542(this.field_11863, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), itemStack2);
            itemEntity.method_6988();
            this.field_11863.method_8649((class_1297)itemEntity);
            this.method_5448();
            this.method_5431();
            return class_9062.method_55644((boolean)this.field_11863.field_9236);
        }
        return super.interactWithPlayerItem(player, handIn, stack, slot);
    }

    public boolean hasVideo() {
        return this.linkedFeedUuid != null;
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, TVBlockEntity tile) {
        if (((Boolean)state.method_11654((class_2769)TVBlock.POWERED)).booleanValue()) {
            int n;
            float duration = tile.getPlayDuration();
            ++tile.soundLoopTicks;
            if ((float)n >= duration) {
                tile.soundLoopTicks = 0;
                class_3414 sound = tile.getPlaySound();
                level.method_45446(pos, sound, class_3419.field_15245, 1.0f, 1.0f, false);
            }
            ++tile.animationTicks;
        } else {
            tile.soundLoopTicks = 0;
            tile.animationTicks = 0;
        }
    }

    private class_3414 getPlaySound() {
        Optional<class_6880<class_3414>> s;
        if (this.tape != null && (s = ((CassetteTape)this.tape.comp_349()).soundEvent()).isPresent()) {
            return (class_3414)s.get().comp_349();
        }
        return (class_3414)VistaMod.TV_STATIC_SOUND.get();
    }

    private int getPlayDuration() {
        if (this.tape != null) {
            return ((CassetteTape)this.tape.comp_349()).soundDuration().orElse(80);
        }
        return 80;
    }

    public int getAnimationTick() {
        return this.animationTicks;
    }
}

