/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.vista.common.TvConnection;
import org.jetbrains.annotations.Nullable;

public final class TvHelper {
    public static void updateConnections(GridAccess g) {
        Square sq = TvHelper.findBiggestSquare(g);
        if (sq != null) {
            TvHelper.setStates(g, sq);
        }
    }

    @Nullable
    public static Square findBiggestSquare(GridAccess g) {
        if (g.get(0, 0) == null) {
            return null;
        }
        Square best = new Square(0, 0, 1);
        HashSet<Square> frontier = new HashSet<Square>();
        HashSet<Square> visited = new HashSet<Square>();
        frontier.add(best);
        visited.add(best);
        while (true) {
            HashSet<Square> next = new HashSet<Square>();
            for (Square sq : frontier) {
                int b = sq.bottom;
                int l = sq.left;
                int s = sq.size;
                TvHelper.propose(g, visited, next, b, l - 1, s + 1, ExpandKind.UL);
                TvHelper.propose(g, visited, next, b, l, s + 1, ExpandKind.UR);
                TvHelper.propose(g, visited, next, b - 1, l - 1, s + 1, ExpandKind.DL);
                TvHelper.propose(g, visited, next, b - 1, l, s + 1, ExpandKind.DR);
            }
            if (next.isEmpty()) break;
            for (Square s : next) {
                if (s.size <= best.size) continue;
                best = s;
            }
            frontier = next;
        }
        return best;
    }

    private static void propose(GridAccess g, Set<Square> visited, Set<Square> next, int b, int l, int s, ExpandKind kind) {
        if (b > 0 || 0 >= b + s || l > 0 || 0 >= l + s) {
            return;
        }
        Square key = new Square(b, l, s);
        if (visited.contains(key)) {
            return;
        }
        if (TvHelper.newBorderIsOn(g, b, l, s, kind)) {
            visited.add(key);
            next.add(key);
        }
    }

    private static boolean newBorderIsOn(GridAccess g, int b, int l, int s, ExpandKind kind) {
        int bottom = b;
        int top = b + s - 1;
        int left = l;
        int right = l + s - 1;
        switch (kind.ordinal()) {
            case 0: {
                for (int x = left; x <= right; ++x) {
                    if (g.get(x, top) != null) continue;
                    return false;
                }
                for (int y = bottom; y < top; ++y) {
                    if (g.get(left, y) != null) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                for (int x = left; x < right; ++x) {
                    if (g.get(x, top) != null) continue;
                    return false;
                }
                for (int y = bottom; y <= top; ++y) {
                    if (g.get(right, y) != null) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                for (int x = left + 1; x <= right; ++x) {
                    if (g.get(x, bottom) != null) continue;
                    return false;
                }
                for (int y = bottom; y <= top; ++y) {
                    if (g.get(left, y) != null) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                for (int x = left; x < right; ++x) {
                    if (g.get(x, bottom) != null) continue;
                    return false;
                }
                for (int y = bottom; y <= top; ++y) {
                    if (g.get(right, y) != null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void setStates(GridAccess grid, Square square) {
        int left = square.left;
        int bottom = square.bottom;
        int top = square.bottom + square.size - 1;
        int right = left + square.size - 1;
        for (int y = bottom; y <= top; ++y) {
            for (int x = left; x <= right; ++x) {
                boolean edgeUp = y == top;
                boolean edgeDown = y == bottom;
                boolean edgeLeft = x == left;
                boolean edgeRight = x == right;
                TvConnection conn = TvConnection.get(!edgeUp, !edgeDown, !edgeLeft, !edgeRight);
                grid.set(x, y, conn);
            }
        }
    }

    public static interface GridAccess {
        @Nullable
        public TvConnection get(int var1, int var2);

        public void set(int var1, int var2, @Nullable TvConnection var3);
    }

    public record Square(int bottom, int left, int size) {
    }

    private static enum ExpandKind {
        UL,
        UR,
        DL,
        DR;

    }
}

