/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.vista.common.ViewFinderBlock;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.mehvahdjukaar.vista.network.ServerBoundSyncViewFinderPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_8710;

public interface ViewFinderAccess {
    public ViewFinderBlockEntity getInternalTile();

    public TileOrEntityTarget makeNetworkTarget();

    public void syncToServer(boolean var1);

    public class_243 getCannonGlobalPosition(float var1);

    public float getCannonGlobalYawOffset(float var1);

    public boolean stillValid(class_1657 var1);

    public void updateClients();

    public Restraint getPitchAndYawRestrains();

    default public boolean shouldRotatePlayerFaceWhenManeuvering() {
        return false;
    }

    default public boolean impedePlayerMovementWhenManeuvering() {
        return true;
    }

    public static ViewFinderAccess find(class_1937 level, TileOrEntityTarget target) {
        Object obj = target.getTarget(level);
        if (obj instanceof ViewFinderBlockEntity) {
            ViewFinderBlockEntity cannon = (ViewFinderBlockEntity)((Object)obj);
            return new Block(cannon);
        }
        if (obj instanceof ViewFinderAccess) {
            ViewFinderAccess cannon = (ViewFinderAccess)obj;
            return cannon;
        }
        return null;
    }

    public static ViewFinderAccess block(ViewFinderBlockEntity cannonBlockTile) {
        return new Block(cannonBlockTile);
    }

    public static class Block
    implements ViewFinderAccess {
        private final ViewFinderBlockEntity blockEntity;

        public Block(ViewFinderBlockEntity tile) {
            this.blockEntity = tile;
        }

        @Override
        public TileOrEntityTarget makeNetworkTarget() {
            return TileOrEntityTarget.of((class_2586)this.blockEntity);
        }

        @Override
        public class_243 getCannonGlobalPosition(float ticks) {
            return this.blockEntity.method_11016().method_46558();
        }

        @Override
        public float getCannonGlobalYawOffset(float partialTicks) {
            return 0.0f;
        }

        @Override
        public ViewFinderBlockEntity getInternalTile() {
            return this.blockEntity;
        }

        @Override
        public void updateClients() {
            class_1937 level = this.blockEntity.method_10997();
            level.method_8413(this.blockEntity.method_11016(), this.blockEntity.method_11010(), this.blockEntity.method_11010(), 3);
        }

        @Override
        public void syncToServer(boolean removeOwner) {
            NetworkHelper.sendToServer((class_8710)new ServerBoundSyncViewFinderPacket(this.blockEntity.getYaw(), this.blockEntity.getPitch(), this.blockEntity.getZoomLevel(), this.blockEntity.isLocked(), removeOwner, TileOrEntityTarget.of((class_2586)this.blockEntity)));
        }

        @Override
        public boolean stillValid(class_1657 player) {
            class_1937 level = player.method_37908();
            float maxDist = 7.0f;
            return !this.blockEntity.method_11015() && level.method_8321(this.blockEntity.method_11016()) == this.blockEntity && this.blockEntity.method_11016().method_19770((class_2374)player.method_19538()) < (double)(maxDist * maxDist);
        }

        @Override
        public Restraint getPitchAndYawRestrains() {
            class_2680 state = this.blockEntity.method_11010();
            return switch (((class_2350)state.method_11654((class_2769)ViewFinderBlock.field_10927)).method_10153()) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11043 -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case class_2350.field_11035 -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case class_2350.field_11034 -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case class_2350.field_11039 -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case class_2350.field_11036 -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case class_2350.field_11033 -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
            };
        }
    }

    public record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

