/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class PictureTapeContent {
    public static final Codec<PictureTapeContent> CODEC = class_1799.field_24671.listOf().xmap(PictureTapeContent::new, p -> p.pictures);
    public static final class_9139<class_9129, PictureTapeContent> STREAM_CODEC = class_1799.field_48350.method_56432(PictureTapeContent::new, p -> p.pictures);
    public static final PictureTapeContent EMPTY = new PictureTapeContent(List.of());
    private final List<class_1799> pictures;
    private final int playSpeed;

    public PictureTapeContent(List<class_1799> pictures, int playSpeed) {
        this.pictures = List.copyOf(pictures);
        this.playSpeed = playSpeed;
    }

    public PictureTapeContent(List<class_1799> pictures) {
        this(pictures, 40);
    }

    public int playbackSpeed() {
        return this.playSpeed;
    }

    public Stream<class_1799> pictures() {
        return this.pictures.stream();
    }

    @Nullable
    public class_1799 getPicture(int index) {
        return this.pictures.get(index);
    }

    public int size() {
        return this.pictures.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PictureTapeContent that = (PictureTapeContent)obj;
        return Objects.equals(this.pictures, that.pictures);
    }

    public int hashCode() {
        return Objects.hash(this.pictures);
    }

    public String toString() {
        return "PictureTapeContent[pictures=" + String.valueOf(this.pictures) + "]";
    }

    public PictureTapeContent withInsertedAtIndex(int index, class_1799 picture) {
        ArrayList<class_1799> newPictures = new ArrayList<class_1799>(List.copyOf(this.pictures));
        if (index < 0 || index > newPictures.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + newPictures.size());
        }
        newPictures.add(index, picture);
        return new PictureTapeContent(newPictures);
    }

    public PictureTapeContent withRemovedAtIndex(int index) {
        ArrayList<class_1799> newPictures = new ArrayList<class_1799>(List.copyOf(this.pictures));
        if (index < 0 || index >= newPictures.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + newPictures.size());
        }
        newPictures.remove(index);
        return new PictureTapeContent(newPictures);
    }

    public PictureTapeContent withPlaySpeed(int speed) {
        return new PictureTapeContent(this.pictures, speed);
    }
}

