/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPhotographSlot;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeContent;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeItem;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3414;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PictureTapeMenu
extends class_1703 {
    public static final int CANCEL_ADDING_PHOTO_BUTTON = -1;
    public static final int PREVIOUS_PAGE_BUTTON = PagingDirection.PREVIOUS.ordinal();
    public static final int NEXT_PAGE_BUTTON = PagingDirection.NEXT.ordinal();
    public static final int PAGE_PHOTO_BUTTON = 2;
    protected final int pictureTapeSlot;
    protected final class_1799 pictureTape;
    protected final List<class_1799> photographSlots = new ArrayList<class_1799>();
    protected final List<AlbumPlayerInventorySlot> playerInventorySlots = new ArrayList<AlbumPlayerInventorySlot>();
    protected class_3915 currentIndex = class_3915.method_17403();
    protected boolean isAddingPhotograph = false;
    protected final Map<Integer, Consumer<class_1657>> buttonActions = new HashMap<Integer, Consumer<class_1657>>(){
        {
            this.put(-1, p -> {
                PictureTapeMenu.this.isAddingPhotograph = false;
                if (!PictureTapeMenu.this.method_34255().method_7960()) {
                    p.method_31548().method_7398(PictureTapeMenu.this.method_34255());
                    PictureTapeMenu.this.method_34254(class_1799.field_8037);
                }
                PictureTapeMenu.this.updatePlayerInventorySlots();
            });
            this.put(PREVIOUS_PAGE_BUTTON, p -> {
                PictureTapeMenu.this.method_7604((class_1657)p, -1);
                PictureTapeMenu.this.setCurrentSpreadIndex(Math.max(0, PictureTapeMenu.this.getCurrentIndex() - 1));
            });
            this.put(NEXT_PAGE_BUTTON, p -> {
                PictureTapeMenu.this.method_7604((class_1657)p, -1);
                PictureTapeMenu.this.setCurrentSpreadIndex(Math.min((PictureTapeMenu.this.getTapeContent().size() - 1) / 2, PictureTapeMenu.this.getCurrentIndex() + 1));
            });
            this.put(2, p -> PictureTapeMenu.this.onPhotoButtonPress((class_1657)p));
        }
    };

    public static PictureTapeMenu fromBuffer(int containerId, class_1661 playerInventory, class_2540 buffer) {
        return new PictureTapeMenu(containerId, playerInventory, buffer.method_10816());
    }

    public PictureTapeMenu(int containerId, class_1661 playerInventory, int albumSlot) {
        this(ExposureCompat.PICTURE_TAPE_MENU.get(), containerId, playerInventory, albumSlot);
    }

    protected PictureTapeMenu(class_3917<? extends class_1703> type, int containerId, class_1661 playerInventory, int albumSlot) {
        super(type, containerId);
        this.pictureTapeSlot = albumSlot;
        this.pictureTape = playerInventory.method_5438(albumSlot);
        if (!(this.pictureTape.method_7909() instanceof PictureTapeItem)) {
            throw new IllegalStateException("Expected PictureTapeItem in slot '" + albumSlot + "'. Got: " + String.valueOf(this.pictureTape));
        }
        this.addPhotographSlots();
        this.addPlayerInventorySlots(playerInventory, 70, 115);
        this.method_17362(this.currentIndex);
    }

    protected void addPhotographSlots() {
        PictureTapeContent content = PictureTapeItem.getContent(this.pictureTape);
        this.photographSlots.addAll(content.pictures().toList());
        this.photographSlots.add(class_1799.field_8037);
        class_1799[] photographs = (class_1799[])content.pictures().toArray(class_1799[]::new);
        class_1277 container = new class_1277(photographs);
        for (int i = 0; i < container.method_5439(); ++i) {
            int x = i % 2 == 0 ? 71 : 212;
            int y = 67;
            AlbumPhotographSlot slot = new AlbumPhotographSlot((class_1263)container, i, x, y){

                public void set(class_1799 stack) {
                    super.set(stack);
                    PictureTapeMenu.this.onPhotographSlotChanged(this.getContainerSlot(), stack);
                }
            };
            this.method_7621((class_1735)slot);
        }
    }

    private void onPhotographSlotChanged(int slotIndex, class_1799 stack) {
        PictureTapeItem.setPictureAtIndex(this.pictureTape, slotIndex, stack);
    }

    private void addPlayerInventorySlots(class_1661 playerInventory, int x, int y) {
        AlbumPlayerInventorySlot slot;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                slot = new AlbumPlayerInventorySlot((class_1263)playerInventory, column + row * 9 + 9, x + column * 18, y + row * 18);
                this.method_7621((class_1735)slot);
                this.playerInventorySlots.add(slot);
            }
        }
        for (int index = 0; index < 9; ++index) {
            final boolean disabled = index == playerInventory.field_7545 && playerInventory.method_7391().method_7909() instanceof PictureTapeItem;
            slot = new AlbumPlayerInventorySlot(this, (class_1263)playerInventory, index, x + index * 18, y + 58){

                public boolean mayPickup(class_1657 player) {
                    return !disabled;
                }

                public boolean mayPlace(class_1799 stack) {
                    return !disabled;
                }
            };
            this.method_7621((class_1735)slot);
            this.playerInventorySlots.add(slot);
        }
    }

    protected void updatePlayerInventorySlots() {
        boolean isInAddingPhotographMode = this.isInAddingPhotographMode();
        for (AlbumPlayerInventorySlot slot : this.playerInventorySlots) {
            slot.setActive(isInAddingPhotographMode);
        }
    }

    public int getAlbumSlot() {
        return this.pictureTapeSlot;
    }

    public boolean isInAddingPhotographMode() {
        return this.isAddingPhotograph;
    }

    public List<AlbumPlayerInventorySlot> getPlayerInventorySlots() {
        return this.playerInventorySlots;
    }

    public PictureTapeContent getTapeContent() {
        return PictureTapeItem.getContent(this.pictureTape);
    }

    public Optional<class_1799> getPictureAtIndex(int pageIndex) {
        PictureTapeContent content = this.getTapeContent();
        if (pageIndex <= content.size() - 1) {
            return Optional.ofNullable(content.getPicture(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<class_1799> getPictureAtIndex() {
        return this.getPictureAtIndex(this.getCurrentIndex());
    }

    public Optional<AlbumPhotographSlot> getCurrentPhotograph() {
        return this.getCurrentPhotograph(this.getCurrentIndex());
    }

    public Optional<AlbumPhotographSlot> getCurrentPhotograph(int index) {
        if (index >= 0 && index < this.photographSlots.size()) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public class_1799 getPhotograph() {
        return this.getCurrentPhotograph().map(class_1735::method_7677).orElse(class_1799.field_8037);
    }

    public int getCurrentIndex() {
        return this.currentIndex.method_17407();
    }

    public void setCurrentSpreadIndex(int spreadIndex) {
        this.currentIndex.method_17404(spreadIndex);
    }

    public boolean method_7604(class_1657 player, int id) {
        @Nullable Consumer<class_1657> buttonAction = this.buttonActions.get(id);
        if (buttonAction != null) {
            buttonAction.accept(player);
            return true;
        }
        return false;
    }

    private void onPhotoButtonPress(class_1657 player) {
        Optional<AlbumPhotographSlot> photographSlot = this.getCurrentPhotograph();
        if (photographSlot.isEmpty()) {
            return;
        }
        AlbumPhotographSlot slot = photographSlot.get();
        if (!slot.hasItem()) {
            this.isAddingPhotograph = true;
        } else {
            class_1799 stack = slot.getItem();
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, false);
            }
            slot.set(class_1799.field_8037);
        }
        this.updatePlayerInventorySlots();
    }

    public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
        if (!this.isInAddingPhotographMode() || slotId < 0 || slotId >= this.field_7761.size()) {
            super.method_7593(slotId, button, clickType, player);
            return;
        }
        class_1735 slot = (class_1735)this.field_7761.get(slotId);
        class_1799 stack = slot.method_7677();
        if (button == 0 && slot instanceof AlbumPlayerInventorySlot && stack.method_7909() instanceof PhotographItem && this.method_34255().method_7960()) {
            int pageIndex = this.getCurrentIndex();
            Optional<AlbumPhotographSlot> photographSlot = this.getCurrentPhotograph(pageIndex);
            if (photographSlot.isEmpty() || !photographSlot.get().getItem().method_7960()) {
                return;
            }
            photographSlot.get().set(stack);
            slot.method_7673(class_1799.field_8037);
            if (player.method_37908().field_9236) {
                player.method_5783((class_3414)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), 0.8f, 1.1f);
            }
            this.isAddingPhotograph = false;
            this.updatePlayerInventorySlots();
        } else {
            super.method_7593(slotId, button, clickType, player);
        }
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_31548().method_5438(this.pictureTapeSlot).method_7909() instanceof PictureTapeItem;
    }
}

