/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.mehvahdjukaar.moonlight.core.client.DummyCamera;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.VistaPlatStuff;
import net.mehvahdjukaar.vista.client.AdaptiveUpdateScheduler;
import net.mehvahdjukaar.vista.client.ModRenderTypes;
import net.mehvahdjukaar.vista.client.TVLiveFeedTexture;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.mehvahdjukaar.vista.common.ViewFinderConnection;
import net.mehvahdjukaar.vista.configs.ClientConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class LiveFeedRendererManager {
    private static final Int2ObjectArrayMap<RenderTarget> CANVASES = new Int2ObjectArrayMap();
    private static final BiMap<UUID, ResourceLocation> LIVE_FEED_LOCATIONS = HashBiMap.create();
    private static final DummyCamera DUMMY_CAMERA = new DummyCamera();
    @VisibleForDebug
    public static final Supplier<AdaptiveUpdateScheduler<ResourceLocation>> SCHEDULER = Suppliers.memoize(() -> AdaptiveUpdateScheduler.builder().baseFps(ClientConfigs.UPDATE_FPS.get()).minFps(ClientConfigs.MIN_UPDATE_FPS.get()).targetBudgetMs(ClientConfigs.THROTTLING_UPDATE_MS.get()).evictAfterTicks(100).guardTargetFps(60.0).build());
    private static long feedCounter = 0L;
    @Nullable
    public static RenderTarget LIVE_FEED_BEING_RENDERED = null;
    @VisibleForDebug
    public static final Map<ResourceLocation, RollingBuffer<Long>> UPDATE_TIMES = new HashMap<ResourceLocation, RollingBuffer<Long>>();

    @Nullable
    public static ResourceLocation requestLiveFeedTexture(Level level, UUID location, int screenSize, boolean requiresUpdate) {
        ViewFinderBlockEntity tile;
        ViewFinderConnection connection = ViewFinderConnection.get(level);
        if (connection != null && (tile = connection.getLinkedViewFinder(level, location)) != null) {
            ResourceLocation feedId = LiveFeedRendererManager.getOrCreateFeedId(location);
            TVLiveFeedTexture texture = (TVLiveFeedTexture)RenderedTexturesManager.requestTexture((ResourceLocation)feedId, () -> new TVLiveFeedTexture(feedId, screenSize * ClientConfigs.RESOLUTION_SCALE.get(), LiveFeedRendererManager::refreshTexture, location));
            if (!requiresUpdate) {
                texture.unMarkForUpdate();
            }
            if (texture.isInitialized()) {
                return texture.getTextureLocation();
            }
            SCHEDULER.get().forceUpdateNextTick(feedId);
        }
        return null;
    }

    private static ResourceLocation getOrCreateFeedId(UUID uuid) {
        ResourceLocation loc = (ResourceLocation)LIVE_FEED_LOCATIONS.get((Object)uuid);
        if (loc == null) {
            loc = VistaMod.res("live_feed_" + feedCounter++);
            LIVE_FEED_LOCATIONS.put((Object)uuid, (Object)loc);
        }
        return loc;
    }

    public static RenderTarget getOrCreateCanvas(int size) {
        RenderTarget canvas = (RenderTarget)CANVASES.get(size);
        if (canvas == null) {
            canvas = new TextureTarget(size, size, true, Minecraft.ON_OSX);
            CANVASES.put(size, (Object)canvas);
        }
        return canvas;
    }

    public static void clear() {
        CANVASES.clear();
        LIVE_FEED_LOCATIONS.clear();
        LiveFeedRendererManager.DUMMY_CAMERA.entity = null;
    }

    public static void onRenderTickEnd() {
        SCHEDULER.get().onEndOfFrame();
    }

    private static void refreshTexture(TVLiveFeedTexture text) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (!mc.isGameLoadFinished() || level == null) {
            return;
        }
        if (mc.isPaused()) {
            return;
        }
        ResourceLocation textureId = text.getTextureLocation();
        SCHEDULER.get().runIfShouldUpdate(textureId, () -> {
            ViewFinderConnection connection;
            if (ClientConfigs.isDebugOn()) {
                UPDATE_TIMES.computeIfAbsent(textureId, k -> new RollingBuffer(20)).push((Object)level.getGameTime());
            }
            if ((connection = ViewFinderConnection.get((Level)level)) == null) {
                return;
            }
            UUID uuid = text.associatedUUID;
            ViewFinderBlockEntity tile = connection.getLinkedViewFinder((Level)level, uuid);
            if (tile == null) {
                return;
            }
            float partialTicks = mc.getTimer().getGameTimeDeltaTicks();
            LiveFeedRendererManager.setupSceneCamera(tile, partialTicks);
            RenderTarget renderTarget = text.getFrameBuffer();
            RenderTarget mainTarget = mc.getMainRenderTarget();
            int size = text.getWidth();
            RenderTarget canvas = LiveFeedRendererManager.getOrCreateCanvas(size);
            canvas.bindWrite(true);
            LIVE_FEED_BEING_RENDERED = canvas;
            float fov = 70.0f * tile.getModifiedFOV(1.0f, 1.0f);
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
            FogRenderer.setupNoFog();
            RenderSystem.enableCull();
            float oldRenderDistance = mc.gameRenderer.renderDistance;
            mc.gameRenderer.renderDistance = Math.min(oldRenderDistance, (float)ClientConfigs.RENDER_DISTANCE.get().intValue());
            LiveFeedRendererManager.renderLevel(mc, canvas, (Camera)DUMMY_CAMERA, fov);
            mc.gameRenderer.renderDistance = oldRenderDistance;
            LiveFeedRendererManager.copyWithShader(canvas, renderTarget, ModRenderTypes.POSTERIZE.apply(canvas));
            LIVE_FEED_BEING_RENDERED = null;
            mainTarget.bindWrite(true);
        });
    }

    private static void setupSceneCamera(ViewFinderBlockEntity tile, float partialTicks) {
        Level level = tile.getLevel();
        float pitch = tile.getPitch(partialTicks);
        float yaw = tile.getYaw(partialTicks);
        if (LiveFeedRendererManager.DUMMY_CAMERA.entity == null) {
            LiveFeedRendererManager.DUMMY_CAMERA.entity = new Display.BlockDisplay(EntityType.BLOCK_DISPLAY, level);
        }
        Entity dummyCameraEntity = DUMMY_CAMERA.getEntity();
        Vec3 pos = tile.getBlockPos().getCenter();
        dummyCameraEntity.setPos(pos);
        dummyCameraEntity.setXRot(pitch);
        dummyCameraEntity.setYRot(yaw + 180.0f);
        DUMMY_CAMERA.setPosition(pos);
        DUMMY_CAMERA.setRotation(yaw, pitch);
    }

    private static void renderLevel(Minecraft mc, RenderTarget target, Camera camera, float fov) {
        DeltaTracker deltaTracker = mc.getTimer();
        GameRenderer gr = mc.gameRenderer;
        LevelRenderer lr = mc.levelRenderer;
        Matrix4f projMatrix = LiveFeedRendererManager.createProjectionMatrix(gr, target, fov);
        PoseStack poseStack = new PoseStack();
        projMatrix.mul((Matrix4fc)poseStack.last().pose());
        gr.resetProjectionMatrix(projMatrix);
        Quaternionf cameraRotation = camera.rotation().conjugate(new Quaternionf());
        Matrix4f cameraMatrix = new Matrix4f().rotation((Quaternionfc)cameraRotation);
        lr.prepareCullFrustum(camera.getPosition(), cameraMatrix, projMatrix);
        lr.renderLevel(deltaTracker, false, camera, gr, gr.lightTexture(), cameraMatrix, projMatrix);
        Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
        VistaPlatStuff.dispatchRenderStageAfterLevel(mc, poseStack, camera, modelViewMatrix, projMatrix);
    }

    private static Matrix4f createProjectionMatrix(GameRenderer gr, RenderTarget target, float fov) {
        Matrix4f matrix4f = new Matrix4f();
        float zoom = 1.0f;
        if (zoom != 1.0f) {
            float zoomX = 0.0f;
            float zoomY = 0.0f;
            matrix4f.translate(zoomX, -zoomY, 0.0f);
            matrix4f.scale(zoom, zoom, 1.0f);
        }
        float depthFar = gr.getDepthFar();
        return matrix4f.perspective(fov * ((float)Math.PI / 180), (float)target.width / (float)target.height, 0.05f, depthFar);
    }

    public static void copyWithShader(RenderTarget src, RenderTarget dst, RenderType rt) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (src == null || dst == null) {
            throw new IllegalArgumentException("Source and destination RenderTargets cannot be null");
        }
        if (src.frameBufferId <= 0 || dst.frameBufferId <= 0) {
            throw new IllegalStateException("Both RenderTargets must have valid framebuffers");
        }
        if (src.getColorTextureId() <= 0 || dst.getColorTextureId() <= 0) {
            throw new IllegalStateException("Both RenderTargets must have valid color textures");
        }
        if (src.width != dst.width || src.height != dst.height) {
            throw new IllegalStateException("RenderTarget sizes must match for shader copy");
        }
        dst.clear(true);
        dst.bindWrite(true);
        RenderSystem.getModelViewMatrix().set((Matrix4fc)new Matrix4f().identity());
        RenderSystem.getProjectionMatrix().set((Matrix4fc)new Matrix4f().identity());
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vc = bufferSource.getBuffer(rt);
        vc.addVertex(-1.0f, -1.0f, 0.0f).setUv(0.0f, 1.0f);
        vc.addVertex(1.0f, -1.0f, 0.0f).setUv(1.0f, 1.0f);
        vc.addVertex(1.0f, 1.0f, 0.0f).setUv(1.0f, 0.0f);
        vc.addVertex(-1.0f, 1.0f, 0.0f).setUv(0.0f, 0.0f);
        bufferSource.endBatch(rt);
    }
}

