/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class MsaaTarget
extends TextureTarget {
    private int msFbo = -1;
    private int msColorRb = -1;
    private int msDepthRb = -1;
    private final int samples = this.clampSamples(4);

    public MsaaTarget(int width, int height, boolean useDepth, boolean clearError) {
        super(width, height, useDepth, clearError);
        this.setupMsaa();
    }

    private int clampSamples(int requested) {
        int max = GL11.glGetInteger((int)36183);
        int s = Math.max(0, Math.min(requested, max));
        return s <= 1 ? 0 : s;
    }

    private void setupMsaa() {
        if (this.samples == 0) {
            return;
        }
        this.msColorRb = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)this.msColorRb);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)32856, (int)this.width, (int)this.height);
        if (this.useDepth) {
            this.msDepthRb = GL30.glGenRenderbuffers();
            GL30.glBindRenderbuffer((int)36161, (int)this.msDepthRb);
            GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)35056, (int)this.width, (int)this.height);
        }
        this.msFbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.msFbo);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36064, (int)36161, (int)this.msColorRb);
        if (this.useDepth) {
            GL30.glFramebufferRenderbuffer((int)36160, (int)33306, (int)36161, (int)this.msDepthRb);
        }
        GL11.glDrawBuffer((int)36064);
        GL11.glReadBuffer((int)36064);
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new IllegalStateException("MSAA FBO incomplete: 0x" + Integer.toHexString(status));
        }
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glEnable((int)32925);
    }

    public void bindWrite(boolean setViewport) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.bindWrite(setViewport));
            return;
        }
        if (this.samples > 0 && this.msFbo > 0) {
            GL30.glBindFramebuffer((int)36160, (int)this.msFbo);
            GL11.glDrawBuffer((int)36064);
        } else {
            GlStateManager._glBindFramebuffer((int)36160, (int)this.frameBufferId);
        }
        if (setViewport) {
            GlStateManager._viewport((int)0, (int)0, (int)this.viewWidth, (int)this.viewHeight);
        }
    }

    public void unbindWrite() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::unbindWrite);
            return;
        }
        if (this.samples > 0 && this.msFbo > 0) {
            GL30.glBindFramebuffer((int)36008, (int)this.msFbo);
            GL11.glReadBuffer((int)36064);
            GL30.glBindFramebuffer((int)36009, (int)this.frameBufferId);
            GL11.glDrawBuffer((int)36064);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)this.width, (int)this.height, (int)16384, (int)9728);
            GL30.glBindFramebuffer((int)36008, (int)0);
            GL30.glBindFramebuffer((int)36009, (int)0);
        }
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    public void destroyBuffers() {
        super.destroyBuffers();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::deleteMsaaObjects);
        } else {
            this.deleteMsaaObjects();
        }
    }

    private void deleteMsaaObjects() {
        if (this.msDepthRb > 0) {
            GL30.glDeleteRenderbuffers((int)this.msDepthRb);
            this.msDepthRb = -1;
        }
        if (this.msColorRb > 0) {
            GL30.glDeleteRenderbuffers((int)this.msColorRb);
            this.msColorRb = -1;
        }
        if (this.msFbo > 0) {
            GL30.glDeleteFramebuffers((int)this.msFbo);
            this.msFbo = -1;
        }
    }
}

