/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.client.LiveFeedRendererManager;
import net.mehvahdjukaar.vista.client.ModRenderTypes;
import net.mehvahdjukaar.vista.client.TapeTextureManager;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.common.TVBlock;
import net.mehvahdjukaar.vista.common.TVBlockEntity;
import net.mehvahdjukaar.vista.configs.ClientConfigs;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompatClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class TvBlockEntityRenderer
implements BlockEntityRenderer<TVBlockEntity> {
    public TvBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public int getViewDistance() {
        return 96;
    }

    public void render(TVBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ResourceLocation texture;
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)TVBlock.POWERED)).booleanValue()) {
            return;
        }
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)TVBlock.FACING);
        LOD lod = LOD.at((BlockEntity)blockEntity);
        if (lod.isPlaneCulled(dir, 0.5f, 0.0f)) {
            return;
        }
        float yaw = dir.toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.translate(-0.5, -0.5, -0.5);
        boolean drawingCamera = LiveFeedRendererManager.LIVE_FEED_BEING_RENDERED != null;
        VertexConsumer vc = null;
        int screenPixelSize = blockEntity.getScreenPixelSize();
        UUID liveFeedId = blockEntity.getLinkedFeedUUID();
        Holder<CassetteTape> tape = blockEntity.getTape();
        ItemStack stack = blockEntity.getDisplayedItem();
        if (liveFeedId != null) {
            boolean shouldUpdate = lod.within(ClientConfigs.UPDATE_DISTANCE.get().doubleValue());
            ResourceLocation tex = LiveFeedRendererManager.requestLiveFeedTexture(blockEntity.getLevel(), liveFeedId, screenPixelSize, shouldUpdate);
            if (tex != null) {
                this.maybeRenderDebug(tex, poseStack, buffer, partialTick);
                vc = TapeTextureManager.getFullSpriteVC(tex, buffer, drawingCamera);
            } else {
                vc = TapeTextureManager.getDefaultTapeVC(buffer, drawingCamera);
            }
        } else if (tape != null) {
            if (drawingCamera) {
                Material mat = TapeTextureManager.getMaterialFlat(tape);
                vc = mat.buffer(buffer, RenderType::text);
            } else {
                Material mat = TapeTextureManager.getMaterial(tape);
                vc = mat.buffer(buffer, t -> ModRenderTypes.CAMERA_DRAW_SPRITE.apply((ResourceLocation)t, mat));
            }
        } else if (VistaMod.EXPOSURE_ON && (texture = ExposureCompatClient.getPictureTextureForRenderer(stack, blockEntity.getAnimationTick())) != null) {
            vc = TapeTextureManager.getFullSpriteVC(texture, buffer, drawingCamera);
        }
        if (vc == null) {
            vc = buffer.getBuffer(ModRenderTypes.NOISE);
        }
        light = 0xF000F0;
        float s = (float)screenPixelSize / 32.0f;
        poseStack.translate(0.5, 0.5, -0.001);
        int lightU = light & 0xFFFF;
        int lightV = light >> 16 & 0xFFFF;
        VertexUtil.addQuad((VertexConsumer)vc, (PoseStack)poseStack, (float)(-s), (float)(-s), (float)s, (float)s, (int)lightU, (int)lightV);
    }

    private void maybeRenderDebug(ResourceLocation tex, PoseStack poseStack, MultiBufferSource buffer, float partialTick) {
        if (!ClientConfigs.isDebugOn()) {
            return;
        }
        poseStack.pushPose();
        try {
            Font font = Minecraft.getInstance().font;
            poseStack.translate(1.0, 1.5, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
            poseStack.scale(0.0625f, -0.0625f, 0.0625f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            RollingBuffer<Long> lastUpdateTimes = LiveFeedRendererManager.UPDATE_TIMES.get(tex);
            double averageUpdateinterval = TvBlockEntityRenderer.calculateAverageUpdateTime(lastUpdateTimes);
            font.drawInBatch(String.format("up rate %.2f", averageUpdateinterval), 0.0f, 0.0f, -1, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, OverlayTexture.NO_OVERLAY, 0xF000F0);
            double updateMs = LiveFeedRendererManager.SCHEDULER.get().getAverageUpdateTimeMs();
            font.drawInBatch(String.format("up ms %.2f", updateMs), 0.0f, -9.0f, -1, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, OverlayTexture.NO_OVERLAY, 0xF000F0);
        }
        catch (Exception ignored) {
            boolean bl = true;
        }
        poseStack.popPose();
    }

    static double calculateAverageUpdateTime(RollingBuffer<Long> lastUpdateTimes) {
        int size = lastUpdateTimes.size();
        if (size < 2) {
            return 0.0;
        }
        long totalDiff = 0L;
        for (int i = 1; i < size; ++i) {
            totalDiff += (Long)lastUpdateTimes.get(i) - (Long)lastUpdateTimes.get(i - 1);
        }
        return (double)totalDiff / ((double)size - 1.0);
    }
}

