/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import net.mehvahdjukaar.vista.common.ViewFinderAccess;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class ViewFinderController {
    protected static ViewFinderAccess access;
    private static CameraType lastCameraType;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    private static float lastCameraYaw;
    private static float lastCameraPitch;

    public static void startControlling(ViewFinderAccess cannonAccess) {
        Minecraft mc = Minecraft.getInstance();
        if (access == null) {
            access = cannonAccess;
            lastCameraType = mc.options.getCameraType();
        }
        mc.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        MutableComponent message = Component.translatable((String)"message.vista.viewfinder.control", (Object[])new Object[]{mc.options.keyShift.getTranslatedKeyMessage(), mc.options.keyAttack.getTranslatedKeyMessage()});
        mc.gui.setOverlayMessage((Component)message, false);
        mc.getNarrator().sayNow((Component)message);
        Camera camera = mc.gameRenderer.getMainCamera();
        ViewFinderBlockEntity tile = access.getInternalTile();
        camera.setRotation(Mth.wrapDegrees((float)tile.getYaw()), Mth.wrapDegrees((float)tile.getPitch()));
    }

    private static void stopControllingAndSync() {
        if (access == null) {
            return;
        }
        access.syncToServer(true);
        ViewFinderController.stopControlling();
    }

    public static void stopControlling() {
        if (access == null) {
            return;
        }
        access = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        if (lastCameraType != null) {
            Minecraft.getInstance().options.setCameraType(lastCameraType);
        }
    }

    public static boolean isActive() {
        return access != null;
    }

    public static boolean isLocked() {
        return access.getInternalTile().isLocked();
    }

    public static boolean setupCamera(Camera camera, BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        Vec3 centerCannonPos = access.getCannonGlobalPosition(partialTick);
        Vec3 targetCameraPos = centerCannonPos.add(0.0, 0.5, 0.0);
        float targetYRot = camera.getYRot() + yawIncrease;
        float targetXRot = Mth.clamp((float)(camera.getXRot() + pitchIncrease), (float)-90.0f, (float)90.0f);
        camera.setPosition(targetCameraPos);
        camera.setRotation(targetYRot, targetXRot);
        lastCameraYaw = camera.getYRot();
        lastCameraPitch = camera.getXRot();
        yawIncrease = 0.0f;
        pitchIncrease = 0.0f;
        float followSpeed = 1.0f;
        ViewFinderBlockEntity tile = access.getInternalTile();
        tile.setPitch(access, Mth.rotLerp((float)followSpeed, (float)tile.getPitch(), (float)lastCameraPitch));
        tile.setRenderYaw(access, lastCameraYaw + access.getCannonGlobalYawOffset(partialTick));
        return true;
    }

    public static boolean onPlayerRotated(double yawAdd, double pitchAdd) {
        if (ViewFinderController.isActive()) {
            if (ViewFinderController.isLocked()) {
                return true;
            }
            float scale = 0.2f * (1.0f - access.getInternalTile().getNormalizedZoomFactor() + 0.01f);
            yawIncrease += (float)(yawAdd * (double)scale);
            pitchIncrease += (float)(pitchAdd * (double)scale);
            if (yawAdd != 0.0 || pitchAdd != 0.0) {
                needsToUpdateServer = true;
            }
            if (access.shouldRotatePlayerFaceWhenManeuvering()) {
                LocalPlayer player = Minecraft.getInstance().player;
                player.turn(Mth.wrapDegrees((double)((double)lastCameraYaw + yawAdd - (double)player.yHeadRot)), Mth.wrapDegrees((double)((double)lastCameraPitch + pitchAdd - (double)player.getXRot())));
                player.yHeadRotO = player.yHeadRot;
                player.xRotO = player.getXRot();
            }
            return true;
        }
        return false;
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        int oldZoom;
        ViewFinderBlockEntity tile;
        int newZoom;
        if (!ViewFinderController.isActive()) {
            return false;
        }
        if (ViewFinderController.isLocked()) {
            return true;
        }
        if (scrollDelta != 0.0 && (newZoom = Math.clamp((long)((int)((double)(tile = access.getInternalTile()).getZoomLevel() + scrollDelta)), 1, tile.getMaxZoom())) != (oldZoom = tile.getZoomLevel())) {
            tile.setZoomLevel(newZoom);
            needsToUpdateServer = true;
            if (newZoom % 4 == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)3.0f));
            }
        }
        return true;
    }

    public static boolean onPlayerAttack() {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        ViewFinderController.toggleLock();
        return true;
    }

    public static boolean onPlayerUse() {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        ViewFinderController.toggleLock();
        return true;
    }

    private static void toggleLock() {
        ViewFinderBlockEntity tile;
        tile.setLocked(!(tile = access.getInternalTile()).isLocked());
        needsToUpdateServer = true;
    }

    public static void onInputUpdate(Input input) {
        if (access.impedePlayerMovementWhenManeuvering()) {
            input.down = false;
            input.up = false;
            input.left = false;
            input.right = false;
            input.forwardImpulse = 0.0f;
            input.leftImpulse = 0.0f;
        }
        input.shiftKeyDown = false;
        input.jumping = false;
    }

    public static void onClientTick(Minecraft mc) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!ViewFinderController.isActive()) {
            return;
        }
        if (access.stillValid((Player)player)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                access.syncToServer(false);
            }
        } else {
            ViewFinderController.stopControllingAndSync();
        }
    }

    public static boolean onEarlyKeyPress(int key, int scanCode, int action, int modifiers) {
        if (!ViewFinderController.isActive()) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        Options options = Minecraft.getInstance().options;
        if (key == 256) {
            ViewFinderController.stopControllingAndSync();
            return true;
        }
        if (options.keyInventory.matches(key, scanCode)) {
            return true;
        }
        if (options.keyJump.matches(key, scanCode)) {
            return true;
        }
        if (options.keyShift.matches(key, scanCode)) {
            ViewFinderController.stopControllingAndSync();
            return true;
        }
        return false;
    }

    public static boolean isZooming() {
        if (ViewFinderController.isActive()) {
            ViewFinderBlockEntity tile = access.getInternalTile();
            return tile.getZoomLevel() > 1;
        }
        return false;
    }

    public static float modifyFOV(float start, float modified, Player player) {
        if (ViewFinderController.isActive()) {
            return access.getInternalTile().getModifiedFOV(start, modified);
        }
        return modified;
    }

    static {
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
    }
}

