/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.vista.common.ViewFinderBlock;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.mehvahdjukaar.vista.network.ServerBoundSyncViewFinderPacket;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public interface ViewFinderAccess {
    public ViewFinderBlockEntity getInternalTile();

    public TileOrEntityTarget makeNetworkTarget();

    public void syncToServer(boolean var1);

    public Vec3 getCannonGlobalPosition(float var1);

    public float getCannonGlobalYawOffset(float var1);

    public boolean stillValid(Player var1);

    public void updateClients();

    public Restraint getPitchAndYawRestrains();

    default public boolean shouldRotatePlayerFaceWhenManeuvering() {
        return false;
    }

    default public boolean impedePlayerMovementWhenManeuvering() {
        return true;
    }

    public static ViewFinderAccess find(Level level, TileOrEntityTarget target) {
        Object obj = target.getTarget(level);
        if (obj instanceof ViewFinderBlockEntity) {
            ViewFinderBlockEntity cannon = (ViewFinderBlockEntity)((Object)obj);
            return new Block(cannon);
        }
        if (obj instanceof ViewFinderAccess) {
            ViewFinderAccess cannon = (ViewFinderAccess)obj;
            return cannon;
        }
        return null;
    }

    public static ViewFinderAccess block(ViewFinderBlockEntity cannonBlockTile) {
        return new Block(cannonBlockTile);
    }

    public static class Block
    implements ViewFinderAccess {
        private final ViewFinderBlockEntity blockEntity;

        public Block(ViewFinderBlockEntity tile) {
            this.blockEntity = tile;
        }

        @Override
        public TileOrEntityTarget makeNetworkTarget() {
            return TileOrEntityTarget.of((BlockEntity)this.blockEntity);
        }

        @Override
        public Vec3 getCannonGlobalPosition(float ticks) {
            return this.blockEntity.getBlockPos().getCenter();
        }

        @Override
        public float getCannonGlobalYawOffset(float partialTicks) {
            return 0.0f;
        }

        @Override
        public ViewFinderBlockEntity getInternalTile() {
            return this.blockEntity;
        }

        @Override
        public void updateClients() {
            Level level = this.blockEntity.getLevel();
            level.sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 3);
        }

        @Override
        public void syncToServer(boolean removeOwner) {
            NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSyncViewFinderPacket(this.blockEntity.getYaw(), this.blockEntity.getPitch(), this.blockEntity.getZoomLevel(), this.blockEntity.isLocked(), removeOwner, TileOrEntityTarget.of((BlockEntity)this.blockEntity)));
        }

        @Override
        public boolean stillValid(Player player) {
            Level level = player.level();
            float maxDist = 7.0f;
            return !this.blockEntity.isRemoved() && level.getBlockEntity(this.blockEntity.getBlockPos()) == this.blockEntity && this.blockEntity.getBlockPos().distToCenterSqr((Position)player.position()) < (double)(maxDist * maxDist);
        }

        @Override
        public Restraint getPitchAndYawRestrains() {
            BlockState state = this.blockEntity.getBlockState();
            return switch (((Direction)state.getValue((Property)ViewFinderBlock.FACING)).getOpposite()) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case Direction.SOUTH -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case Direction.EAST -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case Direction.WEST -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case Direction.UP -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
                case Direction.DOWN -> new Restraint(-360.0f, 360.0f, -180.0f, 180.0f);
            };
        }
    }

    public record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

