/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.ImageRenderer;
import io.github.mortuusars.exposure.client.render.image.RenderedImageInstance;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.AlbumItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.misc.TField;
import net.mehvahdjukaar.moonlight.api.misc.TMethod;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeContent;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeItem;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ExposureCompatClient {
    private static final int TIME_PER_PICTURE = 40;
    private static final TMethod<ImageRenderer, RenderedImageInstance> GET_OR_CREATE_INSTANCE = TMethod.of(ImageRenderer.class, (String)"getOrCreateInstance", (Class[])new Class[]{RenderableImage.class});
    private static final TField<RenderedImageInstance, Boolean> REQUIRES_UPLOAD = TField.of(RenderedImageInstance.class, (String)"requiresUpload");
    private static final TField<RenderedImageInstance, ResourceLocation> TEXTURE_LOCATION = TField.of(RenderedImageInstance.class, (String)"textureLocation");
    private static final TMethod<RenderedImageInstance, Void> UPDATE_TEXTURE = TMethod.of(RenderedImageInstance.class, (String)"updateTexture", (Class[])new Class[0]);

    public static void init() {
        ClientHelper.addClientSetup(() -> MenuScreens.register(ExposureCompat.PICTURE_TAPE_MENU.get(), PictureTapeScreen::new));
    }

    private static ResourceLocation getFrameTexture(ItemStack stack, Frame frame) {
        PhotographStyle style = PhotographStyle.of((ItemStack)stack);
        RenderableImage image = style.process(ExposureClient.renderedExposures().getOrCreate(frame));
        ImageRenderer imageRenderer = ExposureClient.imageRenderer();
        RenderedImageInstance texture = (RenderedImageInstance)GET_OR_CREATE_INSTANCE.invoke((Object)imageRenderer, new Object[]{image});
        ResourceLocation textureLocation = (ResourceLocation)TEXTURE_LOCATION.get((Object)texture);
        if (((Boolean)REQUIRES_UPLOAD.get((Object)texture)).booleanValue()) {
            UPDATE_TEXTURE.invoke((Object)texture, new Object[0]);
            REQUIRES_UPLOAD.set((Object)texture, (Object)false);
        }
        return textureLocation;
    }

    public static ResourceLocation getPictureTextureForRenderer(ItemStack stack, int time) {
        Item item = stack.getItem();
        if (item instanceof PictureTapeItem) {
            PictureTapeItem pi = (PictureTapeItem)item;
            PictureTapeContent content = PictureTapeItem.getContent(stack);
            int size = content.size();
            if (size > 0) {
                ItemStack s = content.getPicture(time / content.playbackSpeed() % size);
                PhotographItem photographItem = (PhotographItem)s.getItem();
                Frame frame = photographItem.getFrame(s);
                return ExposureCompatClient.getFrameTexture(s, frame);
            }
        } else {
            AlbumItem album;
            List content;
            List<ItemStack> photos;
            if (item instanceof PhotographItem) {
                PhotographItem photographItem = (PhotographItem)item;
                Frame frame = photographItem.getFrame(stack);
                return ExposureCompatClient.getFrameTexture(stack, frame);
            }
            if (item instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item;
                List photos2 = stackedPhotographsItem.getPhotographs(stack);
                int size = photos2.size();
                if (size > 0) {
                    ItemAndStack frameItem = (ItemAndStack)photos2.get(time / 40 % size);
                    ItemStack s = frameItem.getItemStack();
                    Frame frame = ((PhotographItem)frameItem.getItem()).getFrame(s);
                    return ExposureCompatClient.getFrameTexture(s, frame);
                }
            } else if (item instanceof AlbumItem && !(photos = (content = (album = (AlbumItem)item).getContent(stack).pages()).stream().map(AlbumPage::photograph).filter(p -> p.getItem() instanceof PhotographItem).toList()).isEmpty()) {
                ItemStack s = photos.get(time / 40 % photos.size());
                PhotographItem photographItem = (PhotographItem)s.getItem();
                Frame frame = photographItem.getFrame(s);
                return ExposureCompatClient.getFrameTexture(s, frame);
            }
        }
        return null;
    }
}

