/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeContent;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PictureTapeItem
extends Item {
    public PictureTapeItem(Item.Properties properties) {
        super(properties);
    }

    public static PictureTapeContent getContent(ItemStack stack) {
        return (PictureTapeContent)stack.getOrDefault(ExposureCompat.PICTURE_TAPE_CONTENT.get(), (Object)PictureTapeContent.EMPTY);
    }

    public static void setContent(ItemStack stack, PictureTapeContent content) {
        stack.set(ExposureCompat.PICTURE_TAPE_CONTENT.get(), (Object)content);
    }

    public static void setPictureAtIndex(ItemStack stack, int index, ItemStack picture) {
        PictureTapeContent content = PictureTapeItem.getContent(stack);
        PictureTapeContent newContent = content.withInsertedAtIndex(index, picture);
        PictureTapeItem.setContent(stack, newContent);
    }

    public static void removePictureAtIndex(ItemStack stack, int index) {
        PictureTapeContent content = PictureTapeItem.getContent(stack);
        PictureTapeContent newContent = content.withRemovedAtIndex(index);
        PictureTapeItem.setContent(stack, newContent);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int albumSlot = usedHand == InteractionHand.OFF_HAND ? 40 : player.getInventory().selected;
            this.open(serverPlayer, itemStack, albumSlot);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void open(ServerPlayer player, final ItemStack albumStack, final int albumSlot) {
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return albumStack.getHoverName();
            }

            @NotNull
            public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new PictureTapeMenu(containerId, playerInventory, albumSlot);
            }
        };
        PlatHelper.openCustomMenu((ServerPlayer)player, (MenuProvider)menuProvider, buffer -> buffer.writeVarInt(albumSlot));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"WIP"));
        int photographsCount = PictureTapeItem.getContent(stack).size();
        if (photographsCount > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.exposure.album.tooltip.photos_count", (Object[])new Object[]{photographsCount}));
        }
    }

    public boolean shouldPlayEquipAnimation(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getItem() != newStack.getItem();
    }
}

