/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumGUI;
import io.github.mortuusars.exposure.client.gui.screen.album.PhotographSlotWidget;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.TextBox;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeMenu;
import net.mehvahdjukaar.vista.integration.exposure.TapeScrollingEntriesListWidget;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PictureTapeScreen
extends AbstractContainerScreen<PictureTapeMenu> {
    protected TapeScrollingEntriesListWidget tapeScrollWidget;
    protected final Pager pager = new Pager().setChangeSound(new SoundEffect(() -> SoundEvents.BOOK_PAGE_TURN)).onPageChanged((oldPage, newPage) -> this.clickButton(PagingDirection.fromChange((int)oldPage, (int)newPage).ordinal()));
    protected final KeyBindings keyBindings;
    protected final List<Page> pages;

    public PictureTapeScreen(PictureTapeMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        KeyBinding[] keyBindingArray = new KeyBinding[5];
        keyBindingArray[0] = Key.press((KeyMapping)Minecrft.options().keyInventory).executes(() -> ((PictureTapeScreen)this).onClose());
        keyBindingArray[1] = Key.press((int)263).or(Key.press((int)65)).executes(() -> ((Pager)this.pager).previousPage());
        keyBindingArray[2] = Key.press((int)262).or(Key.press((int)68)).executes(() -> ((Pager)this.pager).nextPage());
        keyBindingArray[3] = Key.release((int)263).or(Key.press((int)65)).executes(() -> ((Pager)this.pager).resetCooldown());
        keyBindingArray[4] = Key.release((int)262).or(Key.press((int)68)).executes(() -> ((Pager)this.pager).resetCooldown());
        this.keyBindings = KeyBindings.of((KeyBinding[])keyBindingArray);
        this.pages = new ArrayList<Page>();
    }

    protected void init() {
        this.imageWidth = 298;
        this.imageHeight = 188;
        super.init();
        this.titleLabelY = -999;
        this.inventoryLabelX = 69;
        this.inventoryLabelY = -999;
        this.tapeScrollWidget = null;
        this.pages.clear();
        Page leftPage = this.createPage(0);
        this.pages.add(leftPage);
        ImageButton previousPageButton = new ImageButton(this.leftPos + 12, this.topPos + 164, 13, 15, AlbumGUI.PREVIOUS_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.translatable((String)"gui.exposure.previous_page"));
        previousPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure.previous_page")));
        this.addRenderableWidget((GuiEventListener)previousPageButton);
        ImageButton nextPageButton = new ImageButton(this.leftPos + 273, this.topPos + 164, 13, 15, AlbumGUI.NEXT_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.translatable((String)"gui.exposure.next_page"));
        nextPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure.next_page")));
        this.addRenderableWidget((GuiEventListener)nextPageButton);
        int spreadsCount = (int)Math.ceil((float)((PictureTapeMenu)this.getMenu()).getTapeContent().size() / 2.0f);
        this.pager.setPagesCount(spreadsCount).setPreviousPageButton((AbstractButton)previousPageButton).setNextPageButton((AbstractButton)nextPageButton);
    }

    protected void containerTick() {
    }

    protected Page createPage(int xOffset) {
        int x = this.leftPos + xOffset;
        int y = this.topPos;
        Rect2i page = new Rect2i(x, y, 149, 188);
        Rect2i photo = new Rect2i(x + 25, y + 21, 108, 108);
        PhotographSlotWidget photographWidget = new PhotographSlotWidget((Screen)this, photo.getX(), photo.getY(), photo.getWidth(), photo.getHeight(), () -> ((PictureTapeMenu)this.getMenu()).getPhotograph()){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return !PictureTapeScreen.this.isInAddingMode() && super.mouseClicked(mouseX, mouseY, button);
            }

            public boolean isHovered() {
                return !PictureTapeScreen.this.isInAddingMode() && super.isHovered();
            }
        };
        photographWidget.editable(true).primaryAction(widget -> {
            if (!widget.inspectPhotograph() && widget.getPhotograph().isEmpty() && widget.isEditable()) {
                this.clickButton(2);
                Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }).secondaryAction(widget -> {
            if (widget.isEditable() && !widget.getPhotograph().isEmpty()) {
                this.clickButton(2);
                Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get()), (float)0.7f, (float)1.1f));
            }
        });
        this.addRenderableWidget((GuiEventListener)photographWidget);
        return new Page(photo, photographWidget);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateWidgetVisibility();
        this.inventoryLabelY = this.isInAddingMode() ? ((PictureTapeMenu)this.getMenu()).getPlayerInventorySlots().getFirst().y - 12 : -999;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isInAddingMode()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (Slot slot : ((PictureTapeMenu)this.getMenu()).slots) {
                if (slot.getItem().isEmpty() || slot.getItem().getItem() instanceof PhotographItem) continue;
                guiGraphics.blit(AlbumGUI.TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 350, 176.0f, 188.0f, 18, 18, 512, 512);
            }
            RenderSystem.disableBlend();
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void updateWidgetVisibility() {
        for (Page page : this.pages) {
            page.photographWidget.visible = !((PictureTapeMenu)this.getMenu()).getPhotograph().isEmpty() || !this.isInAddingMode();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 15.0f);
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.pose().popPose();
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.isInAddingMode() && this.hoveredSlot != null && !this.hoveredSlot.getItem().isEmpty() && !(this.hoveredSlot.getItem().getItem() instanceof PhotographItem)) {
            return;
        }
        if (!this.isInAddingMode()) {
            for (Page page : this.pages) {
                if (!page.photographWidget.isHoveredOrFocused()) continue;
                page.photographWidget.renderTooltip(guiGraphics, x, y);
                return;
            }
        }
        super.renderTooltip(guiGraphics, x, y);
    }

    @NotNull
    public List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List tooltipLines = super.getTooltipFromContainerItem(stack);
        if (this.isInAddingMode() && this.hoveredSlot != null && this.hoveredSlot.getItem() == stack && stack.getItem() instanceof PhotographItem) {
            tooltipLines.add(Component.empty());
            tooltipLines.add(Component.translatable((String)"gui.exposure.album.left_click_to_add"));
        }
        return tooltipLines;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(AlbumGUI.TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        int currentSpreadIndex = ((PictureTapeMenu)this.getMenu()).getCurrentIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex);
        if (this.isInAddingMode()) {
            AlbumPlayerInventorySlot firstSlot = ((PictureTapeMenu)this.getMenu()).getPlayerInventorySlots().getFirst();
            int x = firstSlot.x - 8;
            int y = firstSlot.y - 18;
            guiGraphics.blit(AlbumGUI.TEXTURE, this.leftPos + x, this.topPos + y, 10, 0.0f, 188.0f, 176, 100, 512, 512);
            for (Page page : this.pages) {
                guiGraphics.blitSprite(PhotographSlotWidget.EMPTY_SPRITES.enabledFocused(), page.photoArea.getX(), page.photoArea.getY(), page.photoArea.getWidth(), page.photoArea.getHeight());
            }
        }
    }

    protected void drawPageNumbers(GuiGraphics guiGraphics, int currentSpreadIndex) {
        Font font = Minecrft.get().font;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.drawString(font, leftPageNumber, this.leftPos + 71 + (8 - font.width(leftPageNumber) / 2), this.topPos + 167, -1, false);
        guiGraphics.drawString(font, rightPageNumber, this.leftPos + 212 + (8 - font.width(rightPageNumber) / 2), this.topPos + 167, -1, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInAddingMode()) {
            if (!(this.isHoveringOverInventory(mouseX, mouseY) || this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, button) && !((PictureTapeMenu)this.getMenu()).getCarried().isEmpty())) {
                this.clickButton(-1);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        boolean handled = super.mouseClicked(mouseX, mouseY, button);
        if (!(this.getFocused() instanceof TextBox)) {
            this.setFocused(null);
        }
        return handled;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isQuickCrafting && !((PictureTapeMenu)this.getMenu()).getCarried().isEmpty() && ((PictureTapeMenu)this.getMenu()).getCarried().getCount() == 1) {
            this.isQuickCrafting = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean handleComponentClicked(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String pageIndexStr = clickEvent.getValue();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.handleComponentClicked(style);
        if (handled && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.onClose();
        }
        return handled;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInAddingMode()) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void clickButton(int buttonId) {
        ((PictureTapeMenu)this.getMenu()).clickMenuButton((Player)Minecrft.player(), buttonId);
        Minecrft.gameMode().handleInventoryButtonClick(((PictureTapeMenu)this.getMenu()).containerId, buttonId);
        if (buttonId == -1) {
            this.setFocused(null);
        }
        if (buttonId == PictureTapeMenu.PREVIOUS_PAGE_BUTTON || buttonId == PictureTapeMenu.NEXT_PAGE_BUTTON) {
            // empty if block
        }
    }

    protected boolean isHoveringOverInventory(double mouseX, double mouseY) {
        if (!this.isInAddingMode()) {
            return false;
        }
        AlbumPlayerInventorySlot firstSlot = ((PictureTapeMenu)this.getMenu()).getPlayerInventorySlots().getFirst();
        int x = firstSlot.x - 8;
        int y = firstSlot.y - 18;
        return this.isHovering(x, y, 176, 100, mouseX, mouseY);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.hasClickedOutside(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.isHoveringOverInventory(mouseX, mouseY);
    }

    protected boolean forcePage(int pageIndex) {
        try {
            int newSpreadIndex = pageIndex / 2;
            if (newSpreadIndex == ((PictureTapeMenu)this.getMenu()).getCurrentIndex() || newSpreadIndex < 0 || newSpreadIndex > ((PictureTapeMenu)this.getMenu()).getTapeContent().size() / 2) {
                return false;
            }
            PagingDirection pagingDirection = newSpreadIndex < ((PictureTapeMenu)this.getMenu()).getCurrentIndex() ? PagingDirection.PREVIOUS : PagingDirection.NEXT;
            for (int pageChanges = 0; !(newSpreadIndex == ((PictureTapeMenu)this.getMenu()).getCurrentIndex() && this.pager.canChangePage(pagingDirection) || pageChanges > 16); ++pageChanges) {
                this.pager.changePage(pagingDirection);
            }
            return true;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot force page: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.isInAddingMode() && (Minecrft.options().keyInventory.matches(keyCode, scanCode) || keyCode == 256)) {
            this.clickButton(-1);
            return true;
        }
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    protected boolean isInAddingMode() {
        return ((PictureTapeMenu)this.getMenu()).isInAddingPhotographMode();
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    protected class Page {
        public final Rect2i photoArea;
        public final PhotographSlotWidget photographWidget;

        private Page(Rect2i photoArea, PhotographSlotWidget photographWidget) {
            this.photoArea = photoArea;
            this.photographWidget = photographWidget;
        }

        public boolean isMouseOver(Rect2i area, double mouseX, double mouseY) {
            return PictureTapeScreen.this.isHovering(area.getX() - PictureTapeScreen.this.leftPos, area.getY() - PictureTapeScreen.this.topPos, area.getWidth(), area.getHeight(), mouseX, mouseY);
        }
    }
}

