/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.worldblocker.commands;

import me.stokmenn.worldblocker.WorldBlocker;
import me.stokmenn.worldblocker.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WorldBlockerCommand
implements CommandExecutor {
    private final WorldBlocker plugin;

    public WorldBlockerCommand(WorldBlocker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("worldblocker.reload")) {
            sender.sendMessage(Config.noPermissionToReload);
            return false;
        }
        boolean oldBlockAllEntities = Config.blockAllEntities;
        boolean oldBlockPlayers = Config.blockPlayers;
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            Config.reload();
            if (Config.blockAllEntities != oldBlockAllEntities) {
                if (Config.blockAllEntities) {
                    Bukkit.getPluginManager().registerEvents((Listener)this.plugin.getEntityPortalListener(), (Plugin)this.plugin);
                } else {
                    HandlerList.unregisterAll((Listener)this.plugin.getEntityPortalListener());
                }
            }
            if (Config.blockPlayers != oldBlockPlayers) {
                if (Config.blockPlayers) {
                    Bukkit.getPluginManager().registerEvents((Listener)this.plugin.getPlayerChangedWorldListener(), (Plugin)this.plugin);
                } else {
                    HandlerList.unregisterAll((Listener)this.plugin.getPlayerChangedWorldListener());
                }
            }
        });
        sender.sendMessage(Config.configReloaded);
        return true;
    }
}

