/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.worldblocker.config;

import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private static JavaPlugin plugin;
    public static boolean blockAllEntities;
    public static boolean blockPlayers;
    public static boolean ignoreImmunePermission;
    public static String immunePermission;
    public static boolean doSendMessage;
    public static Component canNotEnterWorld;
    public static Component noPermissionToReload;
    public static Component configReloaded;
    public static final Set<World> blockedWorlds;

    public static void init(JavaPlugin plugin) {
        Config.plugin = plugin;
        plugin.saveDefaultConfig();
        Config.reload();
    }

    public static void reload() {
        plugin.reloadConfig();
        FileConfiguration config = plugin.getConfig();
        blockAllEntities = config.getBoolean("blockAllEntities", false);
        blockPlayers = config.getBoolean("blockPlayers", true);
        ignoreImmunePermission = config.getBoolean("ignoreImmunePermission", false);
        immunePermission = config.getString("immunePermission", "worldblocker.immune");
        doSendMessage = config.getBoolean("doSendMessage", true);
        canNotEnterWorld = MiniMessage.miniMessage().deserialize((Object)config.getString("canNotEnterWorld", "<red>\u2718 <white>You can't enter this world!"));
        noPermissionToReload = MiniMessage.miniMessage().deserialize((Object)config.getString("noPermissionToReload", "<red>\u2718 <white>You don't have permission to reload Config!"));
        configReloaded = MiniMessage.miniMessage().deserialize((Object)config.getString("configReloaded", "<green>\u2714 <white>Config reloaded!"));
        blockedWorlds.clear();
        for (String worldName : config.getStringList("blockedWorlds")) {
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                blockedWorlds.add(world);
                continue;
            }
            plugin.getLogger().warning("Unknown world in config: " + worldName);
        }
    }

    static {
        blockedWorlds = new HashSet<World>();
    }
}

