/*
 * Decompiled with CFR 0.152.
 */
package by.derovi.jobs.carrier;

import by.derovi.jobs.carrier.EventListener;
import by.derovi.jobs.carrier.Lang;
import by.derovi.jobs.carrier.Truck;
import by.derovi.jobs.carrier.Way;
import by.derovi.jobs.carrier.Ways;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.md_5.bungee.api.ChatColor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class CarrierJob
extends JavaPlugin {
    private static CarrierJob instance;
    public Lang lang;
    public static Economy economy;
    public static int mxBoxCount;
    public static int range;
    public static String itemName;
    public static String itemTitle;
    public static long serverTime;
    public static boolean slow;
    public static HashMap<String, Truck> trucks;
    public static HashMap<String, Long> event1;
    public static HashMap<String, Long> event2;

    public static CarrierJob getInstance() {
        return instance;
    }

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "CarrierJob Enabled!");
        this.loadPlugin();
    }

    public void onDisable() {
        CarrierJob.backAllBoxes();
        this.disablePlugin();
    }

    public void disablePlugin() {
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "CarrierJob Disabled.");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    void loadPlugin() {
        instance = this;
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
        this.saveDefaultConfig();
        this.reloadConfig();
        Ways.load(this);
        this.lang = new Lang(this);
        this.lang.initPhrases();
        if (!new File(this.getDataFolder(), "/lang/ru.yml").exists()) {
            this.lang.saveNewLang();
        } else {
            this.lang.loadLang();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            event1.put(player.getName(), -1L);
            event2.put(player.getName(), -1L);
        }
        mxBoxCount = this.getConfig().getInt("max_box_count");
        itemName = this.getConfig().getString("item-name");
        itemTitle = this.getConfig().getString("title");
        slow = this.getConfig().getBoolean("slow");
        range = this.getConfig().getInt("range");
        CarrierJob.setupEconomy();
        this.startParticles();
        this.startServerTimer();
        this.startOutOfWayCheck();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!");
            return true;
        }
        Player p = (Player)sender;
        if (!cmd.getName().equalsIgnoreCase("carrierjob")) {
            return false;
        }
        if (args.length == 0) {
            if (!p.hasPermission("carrierjob.use")) {
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                p.sendTitle("", "\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043a\u043e\u043c\u0430\u043d\u0434\u0435.");
                return true;
            }
            this.showHelp(p);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!p.isOp()) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u0435.");
                return true;
            }
            this.reloadConfig();
            Ways.reload();
            this.lang.initPhrases();
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "\u041a\u043e\u043d\u0444\u0438\u0433 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.");
            return true;
        }
        if (args[0].equalsIgnoreCase("createway")) {
            if (args.length != 3) {
                p.sendMessage("/carrierjob createway <\u0438\u043c\u044f> <\u0446\u0435\u043d\u0430>");
                return true;
            }
            Material hand = p.getInventory().getItemInMainHand().getType();
            if (hand == Material.AIR || !hand.isBlock()) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0431\u043b\u043e\u043a \u0432 \u0440\u0443\u043a\u0435.");
                return true;
            }
            Ways.createWay(args[1], Integer.parseInt(args[2]), hand);
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "\u041f\u0443\u0442\u044c '" + args[1] + "' \u0441\u043e\u0437\u0434\u0430\u043d.");
            return true;
        }
        if (args[0].equalsIgnoreCase("setpoint1")) {
            if (args.length != 2) {
                p.sendMessage("/carrierjob setpoint1 <\u043f\u0443\u0442\u044c>");
                return true;
            }
            Block b = p.getTargetBlock(null, 200);
            if (b.getType() != Material.CHEST) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0443\u043d\u0434\u0443\u043a.");
                return true;
            }
            Ways.setPointA(args[1], b.getLocation());
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "\u0422\u043e\u0447\u043a\u0430 A \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430.");
            return true;
        }
        if (args[0].equalsIgnoreCase("setpoint2")) {
            if (args.length != 2) {
                p.sendMessage("/carrierjob setpoint2 <\u043f\u0443\u0442\u044c>");
                return true;
            }
            Block b = p.getTargetBlock(null, 200);
            if (!b.getType().name().contains("SIGN")) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0447\u043a\u0443.");
                return true;
            }
            Ways.setPointB(args[1], b.getLocation());
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "\u0422\u043e\u0447\u043a\u0430 B \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430.");
            return true;
        }
        return false;
    }

    private void showHelp(Player p) {
        p.sendMessage(String.valueOf(ChatColor.GOLD) + "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b:");
        p.sendMessage("/carrierjob createway [\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435] [\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c]");
        p.sendMessage("/carrierjob setpoint1 [\u043f\u0443\u0442\u044c]");
        p.sendMessage("/carrierjob setpoint2 [\u043f\u0443\u0442\u044c]");
        p.sendMessage("/carrierjob reload");
    }

    public void startParticles() {
        new BukkitRunnable(){

            public void run() {
                for (String name : trucks.keySet()) {
                    ConfigurationSection cs;
                    Truck truck = trucks.get(name);
                    Player pl = truck.getPlayer();
                    World world = Bukkit.getWorld((String)Ways.getWayConfig().getString(truck.getWay() + ".A.world"));
                    if (world == null || (cs = Ways.getWayConfig().getConfigurationSection(truck.getWay() + ".waypoints")) == null || cs.getKeys(false).size() < 2) continue;
                    ArrayList<Location> points = new ArrayList<Location>();
                    for (String key : cs.getKeys(false)) {
                        int x = cs.getInt(key + ".x");
                        int y = cs.getInt(key + ".y");
                        int z = cs.getInt(key + ".z");
                        points.add(new Location(world, (double)x, (double)y, (double)z));
                    }
                    for (int i = 1; i < points.size(); ++i) {
                        Way w = new Way((Location)points.get(i - 1), (Location)points.get(i));
                        for (Block block : w) {
                            pl.spawnParticle(Particle.CRIT, block.getLocation(), 5);
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 5L);
    }

    public void startServerTimer() {
        serverTime = 0L;
        new BukkitRunnable(){

            public void run() {
                ++serverTime;
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }

    public void startOutOfWayCheck() {
        new BukkitRunnable(){

            public void run() {
                for (String name : trucks.keySet()) {
                    Truck truck = trucks.get(name);
                    Player player = truck.getPlayer();
                    if (player == null) continue;
                    int longest = truck.getLongestSegment();
                    int nearest = truck.getNearestWay(player.getLocation());
                    if (nearest <= longest * 2) continue;
                    player.sendTitle(Lang.get("soFartitle"), Lang.get("soFartitle_2"));
                    CarrierJob.abortTruck(name);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    public static boolean setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return economy != null;
    }

    public static void backAllBoxes() {
        for (String name : trucks.keySet()) {
            CarrierJob.abortTruck(name);
        }
    }

    public static void abortTruck(String name) {
        Truck truck = trucks.remove(name);
        if (truck == null) {
            return;
        }
        Player player = Bukkit.getPlayerExact((String)name);
        if (player == null) {
            return;
        }
        player.removePotionEffect(PotionEffectType.SLOW);
        String way = truck.getWay();
        Material material = Ways.getBlockMaterial(way);
        Location origin = truck.getOrigin();
        if (origin != null && material != null) {
            origin.getBlock().setType(material);
        }
        player.getInventory().clear();
    }

    static {
        economy = null;
        mxBoxCount = 1;
        range = 50;
        itemName = "\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440";
        itemTitle = "&6&l\u0414\u043e\u0441\u0442\u0430\u0432\u043a\u0430 \u0433\u0440\u0443\u0437\u0430";
        slow = true;
        trucks = new HashMap();
        event1 = new HashMap();
        event2 = new HashMap();
    }
}

