/*
 * Decompiled with CFR 0.152.
 */
package by.derovi.jobs.carrier;

import by.derovi.jobs.carrier.CarrierJob;
import by.derovi.jobs.carrier.Lang;
import by.derovi.jobs.carrier.Truck;
import by.derovi.jobs.carrier.Ways;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class EventListener
implements Listener {
    private final CarrierJob plugin;
    private final Logger logger;

    public EventListener(CarrierJob plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block b = e.getClickedBlock();
        if (b == null) {
            return;
        }
        Player p = e.getPlayer();
        for (String wayName : Ways.getWayNames()) {
            Material requiredMat = Ways.getBlockMaterial(wayName);
            if (requiredMat == null) continue;
            if (b.getType().equals((Object)requiredMat)) {
                double distance;
                Location a = Ways.getPointA(wayName);
                if (a == null || a.getWorld() != b.getWorld() || (distance = a.distance(b.getLocation())) > (double)CarrierJob.range) continue;
                if (CarrierJob.trucks.containsKey(p.getName())) {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "\u0412\u044b \u0443\u0436\u0435 \u043d\u0435\u0441\u0451\u0442\u0435 \u0433\u0440\u0443\u0437!");
                    return;
                }
                Truck.startTruck(p, wayName, b.getLocation());
                b.setType(Material.AIR);
                e.setCancelled(true);
                p.sendMessage(String.valueOf(ChatColor.GREEN) + "\u0412\u044b \u0432\u0437\u044f\u043b\u0438 \u0433\u0440\u0443\u0437.");
                this.logger.info(p.getName() + " \u0432\u0437\u044f\u043b \u0433\u0440\u0443\u0437: " + wayName);
                return;
            }
            if (!b.getType().name().contains("SIGN")) continue;
            if (!CarrierJob.trucks.containsKey(p.getName())) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "\u0412\u044b \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043d\u0435\u0441\u0451\u0442\u0435.");
                return;
            }
            Truck truck = CarrierJob.trucks.get(p.getName());
            if (!truck.getWay().equals(wayName)) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "\u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u043f\u0443\u0442\u044c.");
                return;
            }
            Truck.deliver(p, wayName);
            this.logger.info(p.getName() + " \u0434\u043e\u0441\u0442\u0430\u0432\u0438\u043b \u0433\u0440\u0443\u0437: " + wayName);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        CarrierJob.event1.put(e.getPlayer().getName(), -1L);
        CarrierJob.event2.put(e.getPlayer().getName(), -1L);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        String name = e.getPlayer().getName();
        if (CarrierJob.trucks.containsKey(name)) {
            CarrierJob.abortTruck(name);
        }
    }

    @EventHandler
    public void onDie(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (CarrierJob.trucks.containsKey(p.getName())) {
            e.getDrops().clear();
            e.setDroppedExp(0);
            p.sendTitle(Lang.get("deathtitle"), Lang.get("deathtitle_2"));
            CarrierJob.abortTruck(p.getName());
            this.logger.warning(p.getName() + " \u0443\u043c\u0435\u0440 \u0441 \u0433\u0440\u0443\u0437\u043e\u043c.");
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (CarrierJob.trucks.containsKey(p.getName())) {
            e.setCancelled(true);
            this.logger.info(p.getName() + " \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u0432\u044b\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0433\u0440\u0443\u0437.");
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryInteractEvent e) {
        if (CarrierJob.trucks.containsKey(e.getWhoClicked().getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryMove(InventoryDragEvent e) {
        if (CarrierJob.trucks.containsKey(e.getWhoClicked().getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (CarrierJob.trucks.containsKey(e.getWhoClicked().getName())) {
            e.setCancelled(true);
        }
    }
}

