/*
 * Decompiled with CFR 0.152.
 */
package by.derovi.jobs.carrier;

import by.derovi.jobs.carrier.CarrierJob;
import by.derovi.jobs.carrier.Ways;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Truck {
    private final String way;
    private final Player player;
    private final List<Location> boxes = new ArrayList<Location>();
    private final Location origin;
    private int box_count = 0;

    public Truck(String way, Player player, Location origin) {
        this.way = way;
        this.player = player;
        this.origin = origin;
    }

    public static void startTruck(Player p, String wayName, Location origin) {
        CarrierJob.trucks.put(p.getName(), new Truck(wayName, p, origin));
        Truck.giveBox(p, wayName, 0, origin);
        if (CarrierJob.slow && !p.hasPotionEffect(PotionEffectType.SLOW)) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 0, false, false, true));
        }
    }

    public static void giveBox(Player p, String wayName, int count, Location origin) {
        Material material = Ways.getBlockMaterial(wayName);
        if (material == null || material == Material.AIR) {
            return;
        }
        ItemStack cargo = new ItemStack(material, 1);
        p.getInventory().setItem(count, cargo);
        CarrierJob.trucks.get((Object)p.getName()).boxes.add(origin);
    }

    public static void deliver(Player p, String wayName) {
        Economy economy = CarrierJob.economy;
        int reward = Ways.getCost(wayName);
        if (economy != null) {
            economy.depositPlayer((OfflinePlayer)p, (double)reward);
        }
        p.sendTitle(String.valueOf(ChatColor.GREEN) + "\u0413\u0440\u0443\u0437 \u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d!", String.valueOf(ChatColor.GOLD) + "$" + reward, 5, 25, 5);
        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_YES, 1.0f, 1.0f);
        p.removePotionEffect(PotionEffectType.SLOW);
        Location pointA = Ways.getPointA(wayName);
        Material material = Ways.getBlockMaterial(wayName);
        if (pointA != null && material != null) {
            pointA.getBlock().setType(material);
        }
        p.getInventory().clear();
        CarrierJob.abortTruck(p.getName());
    }

    public String getWay() {
        return this.way;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getOrigin() {
        return this.origin;
    }

    public List<Location> getBoxes() {
        return this.boxes;
    }

    public int getBox_count() {
        return this.box_count;
    }

    public int getLongestSegment() {
        return 100;
    }

    public int getNearestWay(Location loc) {
        return 50;
    }
}

