/*
 * Decompiled with CFR 0.152.
 */
package by.derovi.jobs.carrier;

import by.derovi.jobs.carrier.CarrierJob;
import java.io.File;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class Ways {
    private static YamlConfiguration wayConfig;
    private static File file;
    private static final Logger logger;

    public static void load(CarrierJob plugin) {
        file = new File(plugin.getDataFolder(), "ways.yml");
        wayConfig = YamlConfiguration.loadConfiguration((File)file);
        logger.info("[CarrierJob] ways.yml \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.");
    }

    public static void saveWays() {
        try {
            wayConfig.save(file);
            logger.info("[CarrierJob] ways.yml \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d.");
        }
        catch (Exception ex) {
            logger.severe("[CarrierJob] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 ways.yml: " + ex.getMessage());
        }
    }

    public static boolean isWay(String name) {
        return wayConfig.contains(name + ".A") && wayConfig.contains(name + ".B") && wayConfig.contains(name + ".block");
    }

    public static void createWay(String name, int cost, Material material) {
        wayConfig.set(name + ".cost", (Object)cost);
        wayConfig.set(name + ".block", (Object)material.name());
        Ways.saveWays();
    }

    public static void setPointA(String name, Location loc) {
        wayConfig.set(name + ".A.world", (Object)loc.getWorld().getName());
        wayConfig.set(name + ".A.x", (Object)loc.getBlockX());
        wayConfig.set(name + ".A.y", (Object)loc.getBlockY());
        wayConfig.set(name + ".A.z", (Object)loc.getBlockZ());
        Ways.saveWays();
    }

    public static void setPointB(String name, Location loc) {
        wayConfig.set(name + ".B.world", (Object)loc.getWorld().getName());
        wayConfig.set(name + ".B.x", (Object)loc.getBlockX());
        wayConfig.set(name + ".B.y", (Object)loc.getBlockY());
        wayConfig.set(name + ".B.z", (Object)loc.getBlockZ());
        Ways.saveWays();
    }

    public static Location getPointA(String wayName) {
        String worldName = wayConfig.getString(wayName + ".A.world");
        Integer x = wayConfig.getInt(wayName + ".A.x");
        Integer y = wayConfig.getInt(wayName + ".A.y");
        Integer z = wayConfig.getInt(wayName + ".A.z");
        if (worldName == null || x == null || y == null || z == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        return world != null ? new Location(world, (double)x.intValue(), (double)y.intValue(), (double)z.intValue()) : null;
    }

    public static Location getPointB(String wayName) {
        String worldName = wayConfig.getString(wayName + ".B.world");
        Integer x = wayConfig.getInt(wayName + ".B.x");
        Integer y = wayConfig.getInt(wayName + ".B.y");
        Integer z = wayConfig.getInt(wayName + ".B.z");
        if (worldName == null || x == null || y == null || z == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        return world != null ? new Location(world, (double)x.intValue(), (double)y.intValue(), (double)z.intValue()) : null;
    }

    public static Material getBlockMaterial(String wayName) {
        String matName = wayConfig.getString(wayName + ".block");
        if (matName == null) {
            logger.warning("[CarrierJob] \u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u0432 \u043f\u0443\u0442\u0438 '" + wayName + "'");
            return Material.AIR;
        }
        Material material = Material.getMaterial((String)matName.toUpperCase());
        if (material == null) {
            logger.warning("[CarrierJob] \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b: " + matName);
            return Material.AIR;
        }
        return material;
    }

    public static int getCost(String wayName) {
        return wayConfig.getInt(wayName + ".cost");
    }

    public static YamlConfiguration getWayConfig() {
        return wayConfig;
    }

    public static Set<String> getWayNames() {
        return wayConfig.getKeys(false);
    }

    public static void reload() {
        Ways.load(CarrierJob.getInstance());
        logger.info("[CarrierJob] \u041f\u0443\u0442\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b.");
    }

    static {
        logger = Bukkit.getLogger();
    }
}

