/*
 * Decompiled with CFR 0.152.
 */
package btw.mixces.animatium;

import btw.mixces.animatium.command.AnimatiumCommand;
import btw.mixces.animatium.config.AnimatiumConfig;
import btw.mixces.animatium.mixins.accessor.RenderPipelinesAccessor;
import btw.mixces.animatium.packet.AnimatiumInfoPayloadPacket;
import btw.mixces.animatium.packet.RequestInfoPayloadPacket;
import btw.mixces.animatium.packet.SetFeaturesPayloadPacket;
import btw.mixces.animatium.util.Feature;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_10789;
import net.minecraft.class_10799;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class AnimatiumClient
implements ClientModInitializer {
    public static boolean ENABLED = true;
    public static List<Feature> ENABLED_FEATURES = new ArrayList<Feature>();
    private static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("animatium").orElseThrow(() -> new RuntimeException("Mod not found"));
    private static final String[] VERSION_PARTS = MOD_CONTAINER.getMetadata().getVersion().getFriendlyString().split("-");
    public static Double VERSION = Double.parseDouble(VERSION_PARTS[0]);
    public static final RenderPipeline LEGACY_SKY_PIPELINE = RenderPipelinesAccessor.registerPipeline(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56850}).withLocation("pipeline/legacy_sky").withVertexShader("core/position").withFragmentShader("core/position").withDepthWrite(false).withVertexFormat(class_290.field_1592, VertexFormat.class_5596.field_27382).build());
    public static final RenderPipeline LEGACY_GLINT_PIPELINE = RenderPipelinesAccessor.registerPipeline(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56849, class_10799.field_56847}).withLocation(AnimatiumClient.getPath("pipeline/legacy_glint")).withVertexShader(AnimatiumClient.getPath("core/legacy_glint")).withFragmentShader(AnimatiumClient.getPath("core/legacy_glint")).withColorWrite(true, false).withCull(true).withBlend(BlendFunction.GLINT).withDepthTestFunction(DepthTestFunction.EQUAL_DEPTH_TEST).withSampler("Sampler0").withUniform("GlintColor", class_10789.field_56745).withUniform("TextureMat", class_10789.field_56747).withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).build());
    private static final File STATE_FILE = new File(FabricLoader.getInstance().getGameDir().toFile(), "animatium_state.txt");

    public static AnimatiumInfoPayloadPacket getInfoPayload() {
        return new AnimatiumInfoPayloadPacket(VERSION, null);
    }

    public static class_2960 getPath(String path) {
        return class_2960.method_60655((String)"animatium", (String)path);
    }

    public static void loadEnabledState() throws IOException {
        if (STATE_FILE.exists()) {
            ENABLED = Files.readString(STATE_FILE.toPath()).equals("true");
        } else if (!AnimatiumClient.saveEnabledState()) {
            System.err.println("Failed to save enabled state...");
        }
    }

    public static boolean saveEnabledState() {
        boolean success = true;
        try {
            if (!STATE_FILE.exists()) {
                success = STATE_FILE.createNewFile();
            }
            if (success) {
                Files.writeString(STATE_FILE.toPath(), (CharSequence)String.valueOf(ENABLED), new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public void onInitializeClient() {
        AnimatiumConfig.load();
        try {
            AnimatiumClient.loadEnabledState();
        }
        catch (IOException e) {
            ENABLED = true;
            System.err.println("Failed to load enabled state, defaulting to true...");
        }
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60654((String)"animatium:classic_textures"), (ModContainer)MOD_CONTAINER, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (environment.field_25422) {
                dispatcher.register(AnimatiumCommand.create());
            }
        });
        ClientLoginConnectionEvents.DISCONNECT.register((packet, client) -> ENABLED_FEATURES.clear());
        ClientConfigurationConnectionEvents.DISCONNECT.register((packet, client) -> ENABLED_FEATURES.clear());
        ClientPlayConnectionEvents.DISCONNECT.register((packet, client) -> ENABLED_FEATURES.clear());
        PayloadTypeRegistry.playC2S().register(AnimatiumInfoPayloadPacket.PAYLOAD_ID, AnimatiumInfoPayloadPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SetFeaturesPayloadPacket.PAYLOAD_ID, SetFeaturesPayloadPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(SetFeaturesPayloadPacket.PAYLOAD_ID, (payload, context) -> context.client().method_63588(() -> {
            ENABLED_FEATURES.clear();
            ENABLED_FEATURES.addAll(payload.features());
        }));
        PayloadTypeRegistry.playS2C().register(RequestInfoPayloadPacket.PAYLOAD_ID, RequestInfoPayloadPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(RequestInfoPayloadPacket.PAYLOAD_ID, (payload, context) -> context.client().method_63588(() -> ClientPlayNetworking.send((class_8710)AnimatiumClient.getInfoPayload())));
    }
}

