/*
 * Decompiled with CFR 0.152.
 */
package btw.mixces.animatium.util;

import btw.mixces.animatium.config.AnimatiumConfig;
import btw.mixces.animatium.util.EntityUtils;
import btw.mixces.animatium.util.ItemClassUtils;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_10444;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1758;
import net.minecraft.class_1764;
import net.minecraft.class_1776;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1814;
import net.minecraft.class_1820;
import net.minecraft.class_2215;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2309;
import net.minecraft.class_2337;
import net.minecraft.class_2440;
import net.minecraft.class_2484;
import net.minecraft.class_2488;
import net.minecraft.class_2533;
import net.minecraft.class_2577;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9463;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private static final ThreadLocal<@Nullable class_10444> RENDER_STATE = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<@Nullable class_1799> STACK = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<@Nullable class_811> DISPLAY_CONTEXT = ThreadLocal.withInitial(() -> null);

    public static void set(class_10444 renderState, class_1799 stack, class_811 displayContext) {
        RENDER_STATE.remove();
        STACK.remove();
        DISPLAY_CONTEXT.remove();
        RENDER_STATE.set(renderState);
        STACK.set(stack);
        DISPLAY_CONTEXT.set(displayContext);
    }

    @Nullable
    public static class_10444 getRenderState() {
        return RENDER_STATE.get();
    }

    @Nullable
    public static class_1799 getStack() {
        return STACK.get();
    }

    @Nullable
    public static class_811 getDisplayContext() {
        return DISPLAY_CONTEXT.get();
    }

    public static boolean isFishingRodItem(class_1799 stack) {
        if (!stack.method_7960()) {
            class_1792 item = stack.method_7909();
            return item instanceof class_1787 || item instanceof class_1758;
        }
        return false;
    }

    public static boolean isRangedWeaponItem(class_1799 stack) {
        if (!stack.method_7960()) {
            return stack.method_7909() instanceof class_1811;
        }
        return false;
    }

    public static boolean isHandheldItem(class_1799 stack) {
        if (!stack.method_7960()) {
            return ItemClassUtils.isDiggerItem(stack) || ItemClassUtils.isSwordItem(stack) || ItemUtils.isFishingRodItem(stack) || List.of(class_1802.field_49814, class_1802.field_8547, class_1802.field_8600, class_1802.field_49821, class_1802.field_8894).contains(stack.method_7909());
        }
        return false;
    }

    public static boolean isThinBlockItem(class_1799 stack) {
        if (!stack.method_7960()) {
            class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
            return block instanceof class_2577 || block instanceof class_2533 || block instanceof class_2440 || block instanceof class_2488 || block instanceof class_2309;
        }
        return false;
    }

    public static boolean isSkullBlock(class_1799 stack) {
        if (!stack.method_7960()) {
            return class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2484;
        }
        return false;
    }

    public static boolean isBlockItemBlacklisted(class_1799 stack) {
        if (!stack.method_7960()) {
            class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
            return block instanceof class_2215 || block instanceof class_2337 || block instanceof class_2244 || ItemUtils.isSkullBlock(stack);
        }
        return false;
    }

    public static boolean isItemBlacklisted(class_1799 stack) {
        if (!stack.method_7960()) {
            class_1792 item = stack.method_7909();
            return ItemClassUtils.isShieldItem(item) || ItemUtils.isBlockItemBlacklisted(stack) || item instanceof class_1764;
        }
        return false;
    }

    public static boolean isSwingItemBlacklisted(class_1799 stack) {
        if (!stack.method_7960()) {
            class_1792 item = stack.method_7909();
            return item instanceof class_9463 || item instanceof class_1755 || item instanceof class_1820 || item instanceof class_1776;
        }
        return false;
    }

    public static boolean isBlock3d(class_1799 stack, class_10444 itemStackRenderState) {
        if (!stack.method_7960()) {
            return stack.method_7909() instanceof class_1747 && itemStackRenderState.method_65607();
        }
        return false;
    }

    public static void applyLegacyFirstpersonTransforms(class_4587 poseStack, int direction, Runnable runnable) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)direction * 45.0f));
        poseStack.method_22905(0.4f, 0.4f, 0.4f);
        runnable.run();
        poseStack.method_22905(2.5f, 2.5f, 2.5f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)direction * -45.0f));
    }

    public static boolean shoulditemPositionsInThirdPerson(class_10017 entityState) {
        if (AnimatiumConfig.instance().itemPositionsInThirdPerson) {
            return true;
        }
        class_1297 entity = EntityUtils.getEntityByState(entityState);
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return AnimatiumConfig.instance().thirdPersonSwordBlockingPosition && livingEntity.method_6039();
        }
        return false;
    }

    public static int getLegacyDurabilityColorValue(class_1799 stack) {
        double value = 255.0 - (double)stack.method_7919() * 255.0 / (double)stack.method_7936();
        if (!Double.isNaN(value)) {
            return (int)Math.round(value);
        }
        return 0;
    }

    public static class_1814 getOldItemRarity(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (List.of(class_1802.field_8463, class_1802.field_8301).contains(item)) {
            return class_1814.field_8903;
        }
        if (List.of(class_1802.field_8137, class_1802.field_8833, class_1802.field_8712).contains(item)) {
            return class_1814.field_8907;
        }
        if (item == class_1802.field_8367) {
            return class_1814.field_8904;
        }
        if (item == class_1802.field_8547) {
            return class_1814.field_8906;
        }
        return stack.method_7932();
    }

    public static boolean shouldInstantlyReplaceVisibleItem1_8(class_1799 prevStack, class_1799 currentStack) {
        boolean itemsMatch = class_1799.method_7984((class_1799)prevStack, (class_1799)currentStack);
        boolean durabilitiesMatch = prevStack.method_7919() == currentStack.method_7919();
        boolean countMatch = prevStack.method_7947() == currentStack.method_7947();
        return itemsMatch && (!durabilitiesMatch || !countMatch);
    }
}

