/*
 * Decompiled with CFR 0.152.
 */
package btw.mixces.animatium.util;

import btw.mixces.animatium.config.AnimatiumConfig;
import btw.mixces.animatium.mixins.accessor.ClientLevelDataAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_291;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_5539;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;

public final class RenderUtils {
    private static float LINE_WIDTH = -1.0f;
    private static Vector3f GLINT_COLOR = new Vector3f(0.5019608f, 0.2509804f, 0.8f);

    public static float getLineWidth(Float def) {
        if (LINE_WIDTH == -1.0f) {
            return def == null ? RenderSystem.getShaderLineWidth() : def.floatValue();
        }
        return LINE_WIDTH;
    }

    public static void setLineWidth(float width) {
        LINE_WIDTH = width;
    }

    public static Vector3f getGlintColor() {
        return GLINT_COLOR;
    }

    public static void setGlintColor(Vector3f vector3f) {
        GLINT_COLOR = vector3f;
    }

    public static void setGlintColor(float red, float green, float blue) {
        GLINT_COLOR = new Vector3f(red, green, blue);
    }

    public static double getLevelHorizonHeight(class_638 level) {
        if (AnimatiumConfig.instance().skyHorizonHeight) {
            if (((ClientLevelDataAccessor)level.method_28104()).isFlatWorld()) {
                return 0.0;
            }
            return 63.0;
        }
        return level.method_28104().method_28105((class_5539)level);
    }

    public static void fillVerticalLine(class_332 context, int startX, int startY, int endX, int endY, int color) {
        context.method_51737(startX, startY, startX + 1, startY + endX, endY, color);
    }

    public static void fillVerticalGradientLine(class_332 context, int i, int j, int k, int l, int startColor, int endColor) {
        context.method_33284(i, j, i + 1, j + k, l, startColor, endColor);
    }

    public static void fillHorizontalLine(class_332 context, int startX, int startY, int endX, int endY, int color) {
        context.method_51737(startX, startY, startX + endX, startY + 1, endY, color);
    }

    public static void fillRectangle(class_332 context, int startX, int startY, int endX, int endY, int padding, int color) {
        context.method_51737(startX, startY, startX + endX, startY + endY, padding, color);
    }

    public static void buildSkyHalf(class_4588 vertexConsumer, float y, boolean bottom) {
        int width = 64;
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float g = k;
                float h = k + 64;
                if (bottom) {
                    float b = g;
                    g = h;
                    h = b;
                }
                vertexConsumer.method_22912(g, y, (float)l);
                vertexConsumer.method_22912(h, y, (float)l);
                vertexConsumer.method_22912(h, y, (float)(l + 64));
                vertexConsumer.method_22912(g, y, (float)(l + 64));
            }
        }
    }

    public static void renderBlueVoidSky(class_638 level, class_291 blueVoidSkyBuffer, int skyColor, double depth) {
        Vector3f skyColorVec = class_9848.method_64963((int)skyColor);
        if (level.method_28103().method_28113()) {
            RenderSystem.setShaderColor((float)(skyColorVec.x * 0.2f + 0.04f), (float)(skyColorVec.y * 0.2f + 0.04f), (float)(skyColorVec.z * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)skyColorVec.x, (float)skyColorVec.y, (float)skyColorVec.z, (float)1.0f);
        }
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate(0.0f, -((float)(depth - 16.0)), 0.0f);
        blueVoidSkyBuffer.method_65176(class_1921.method_65218());
        modelViewStack.popMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

