/*
 * Decompiled with CFR 0.152.
 */
package btw.mixces.animatium;

import btw.mixces.animatium.command.AnimatiumCommand;
import btw.mixces.animatium.config.AnimatiumConfig;
import btw.mixces.animatium.mixins.accessor.RenderPipelinesAccessor;
import btw.mixces.animatium.packet.AnimatiumInfoPayloadPacket;
import btw.mixces.animatium.packet.RequestInfoPayloadPacket;
import btw.mixces.animatium.packet.SetFeaturesPayloadPacket;
import btw.mixces.animatium.util.Feature;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_10799;
import net.minecraft.class_11605;
import net.minecraft.class_11630;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnimatiumClient
implements ClientModInitializer {
    public static final String MOD_ID = "animatium";
    public static boolean ENABLED = true;
    public static List<Feature> ENABLED_FEATURES = new ArrayList<Feature>();
    private static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("animatium").orElseThrow(() -> new RuntimeException("Mod not found"));
    private static final String[] VERSION_PARTS = MOD_CONTAINER.getMetadata().getVersion().getFriendlyString().split("-");
    public static Double VERSION = Double.parseDouble(VERSION_PARTS[0]);
    @Nullable
    public static String DEVELOPMENT_VERSION = VERSION_PARTS[1];
    private static boolean hasVFP = false;
    private static final RenderPipeline.Snippet LEGACY_SKY_PIPELINE_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60127}).withLocation(AnimatiumClient.id("pipeline/legacy_sky")).withVertexShader(AnimatiumClient.id("core/legacy_sky")).withFragmentShader(AnimatiumClient.id("core/legacy_sky")).withDepthWrite(false).withVertexFormat(class_290.field_1592, VertexFormat.class_5596.field_27382).buildSnippet();
    public static final RenderPipeline LEGACY_SKY_PIPELINE = RenderPipelinesAccessor.registerPipeline(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{LEGACY_SKY_PIPELINE_SNIPPET}).withLocation(AnimatiumClient.id("pipeline/legacy_sky")).build());
    public static final RenderPipeline LEGACY_SKY_PLANAR_FOG_PIPELINE = RenderPipelinesAccessor.registerPipeline(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{LEGACY_SKY_PIPELINE_SNIPPET}).withLocation(AnimatiumClient.id("pipeline/legacy_sky_planar_fog")).withShaderDefine("PLANAR_FOG").build());
    public static final RenderPipeline LEGACY_GLINT_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60127}).withLocation(AnimatiumClient.id("pipeline/legacy_glint")).withVertexShader(AnimatiumClient.id("core/legacy_glint")).withFragmentShader(AnimatiumClient.id("core/legacy_glint")).withColorWrite(true, false).withCull(true).withBlend(BlendFunction.GLINT).withDepthTestFunction(DepthTestFunction.EQUAL_DEPTH_TEST).withSampler("Sampler0").withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).build());
    private static final File STATE_FILE = new File(FabricLoader.getInstance().getGameDir().toFile(), "animatium_state.txt");
    private static final class_11605 ANIMATIUM_DEBUG_CATEGORY = new class_11605((class_2561)class_2561.method_43471((String)"animatium.category.debug"), 9999.0f);
    private static final class_2960 ANIMATIUM_GROUP = AnimatiumClient.id("debug");

    public static AnimatiumInfoPayloadPacket getInfoPayload() {
        return new AnimatiumInfoPayloadPacket(VERSION, DEVELOPMENT_VERSION);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static boolean isVFPInstalled() {
        return hasVFP;
    }

    public static void loadEnabledState() throws IOException {
        if (STATE_FILE.exists()) {
            ENABLED = Files.readString(STATE_FILE.toPath()).equals("true");
        } else if (!AnimatiumClient.saveEnabledState()) {
            System.err.println("Failed to save enabled state...");
        }
    }

    public static boolean saveEnabledState() {
        boolean success = true;
        try {
            if (!STATE_FILE.exists()) {
                success = STATE_FILE.createNewFile();
            }
            if (success) {
                Files.writeString(STATE_FILE.toPath(), (CharSequence)String.valueOf(ENABLED), new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public void onInitializeClient() {
        AnimatiumConfig.load();
        try {
            AnimatiumClient.loadEnabledState();
        }
        catch (IOException e) {
            ENABLED = true;
            System.err.println("Failed to load enabled state, defaulting to true...");
        }
        hasVFP = FabricLoader.getInstance().isModLoaded("viafabricplus");
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)AnimatiumClient.id("classic_textures"), (ModContainer)MOD_CONTAINER, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, context) -> dispatcher.register(AnimatiumCommand.create()));
        ClientLoginConnectionEvents.DISCONNECT.register((packet, client) -> ENABLED_FEATURES.clear());
        ClientConfigurationConnectionEvents.DISCONNECT.register((packet, client) -> ENABLED_FEATURES.clear());
        ClientPlayConnectionEvents.DISCONNECT.register((packet, client) -> ENABLED_FEATURES.clear());
        PayloadTypeRegistry.configurationS2C().register(SetFeaturesPayloadPacket.PAYLOAD_ID, SetFeaturesPayloadPacket.CODEC);
        ClientConfigurationNetworking.registerGlobalReceiver(SetFeaturesPayloadPacket.PAYLOAD_ID, (payload, context) -> context.client().method_63588(() -> {
            ENABLED_FEATURES.clear();
            ENABLED_FEATURES.addAll(payload.features());
        }));
        PayloadTypeRegistry.playS2C().register(SetFeaturesPayloadPacket.PAYLOAD_ID, SetFeaturesPayloadPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(SetFeaturesPayloadPacket.PAYLOAD_ID, (payload, context) -> context.client().method_63588(() -> {
            ENABLED_FEATURES.clear();
            ENABLED_FEATURES.addAll(payload.features());
        }));
        PayloadTypeRegistry.playC2S().register(AnimatiumInfoPayloadPacket.PAYLOAD_ID, AnimatiumInfoPayloadPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RequestInfoPayloadPacket.PAYLOAD_ID, RequestInfoPayloadPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(RequestInfoPayloadPacket.PAYLOAD_ID, (payload, context) -> context.client().method_63588(() -> ClientPlayNetworking.send((class_8710)AnimatiumClient.getInfoPayload())));
        class_11631.method_72763((class_2960)ANIMATIUM_GROUP, (class_11632)new class_11632(this){

            public void method_72751(class_11630 debugScreenDisplayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk2) {
                if (!ENABLED_FEATURES.isEmpty()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add("Animatium Enabled Server Features:");
                    for (Feature feature : ENABLED_FEATURES) {
                        list.add(" - " + class_2561.method_43471((String)feature.getTranslateKey()).getString());
                    }
                    debugScreenDisplayer.method_72744(ANIMATIUM_GROUP, list);
                }
            }

            public boolean method_72753(boolean bl) {
                return true;
            }

            @NotNull
            public class_11605 method_72759() {
                return ANIMATIUM_DEBUG_CATEGORY;
            }
        });
    }
}

