/*
 * Decompiled with CFR 0.152.
 */
package btw.mixces.animatium.util;

import btw.mixces.animatium.AnimatiumClient;
import btw.mixces.animatium.config.AnimatiumConfig;
import btw.mixces.animatium.mixins.accessor.ClientLevelDataAccessor;
import btw.mixces.animatium.util.DynamicTransformsBuilder;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_5539;
import net.minecraft.class_638;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;

public final class RenderUtils {
    private static float LINE_WIDTH = -1.0f;
    private static GpuBuffer animatium$blueVoidBuffer = null;

    public static float getLineWidth(Float def) {
        if (LINE_WIDTH == -1.0f) {
            return def == null ? RenderSystem.getShaderLineWidth() : def.floatValue();
        }
        return LINE_WIDTH;
    }

    public static void setLineWidth(float width) {
        LINE_WIDTH = width;
    }

    public static double getLevelHorizonHeight(class_638 level) {
        if (AnimatiumConfig.instance().skyHorizonHeight) {
            if (((ClientLevelDataAccessor)level.method_28104()).animatium$isFlatWorld()) {
                return 0.0;
            }
            return 63.0;
        }
        return level.method_28104().method_28105((class_5539)level);
    }

    public static void fillVerticalLine(class_332 context, int x, int y, int length, int color) {
        context.method_25294(x, y, x + 1, y + length, color);
    }

    public static void fillVerticalGradientLine(class_332 context, int x, int y, int length, int startColor, int endColor) {
        context.method_25296(x, y, x + 1, y + length, startColor, endColor);
    }

    public static void fillHorizontalLine(class_332 context, int x, int y, int length, int color) {
        context.method_25294(x, y, x + length, y + 1, color);
    }

    public static void fillRectangle(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + height, color);
    }

    public static void drawBuffer(class_287 builder, class_276 renderTarget, RenderPipeline renderPipeline) {
        VertexFormat.class_5595 indexType;
        GpuBuffer indexBuffer;
        GpuBuffer vertexBuffer;
        int indexCount;
        try (class_9801 meshData = builder.method_60800();){
            indexCount = meshData.method_60822().comp_751();
            vertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
            if (meshData.method_60821() == null) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                indexBuffer = autoStorageIndexBuffer.method_68274(meshData.method_60822().comp_751());
                indexType = autoStorageIndexBuffer.method_31924();
            } else {
                indexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
                indexType = meshData.method_60822().comp_753();
            }
        }
        catch (Exception e) {
            vertexBuffer = null;
            indexBuffer = null;
            indexType = null;
            indexCount = 0;
        }
        if (vertexBuffer == null) {
            throw new RuntimeException("Vertex buffer was null when trying to render buffer.");
        }
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Immediate Rendering", renderTarget.method_71639(), OptionalInt.empty(), renderTarget.field_1478 ? renderTarget.method_71640() : null, OptionalDouble.empty());){
            renderPass.setPipeline(renderPipeline);
            renderPass.setVertexBuffer(0, vertexBuffer);
            renderPass.setIndexBuffer(indexBuffer, indexType);
            for (int i = 0; i < 12; ++i) {
                GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)i);
                if (gpuTexture == null) continue;
                renderPass.bindSampler("Sampler" + i, gpuTexture);
            }
            renderPass.drawIndexed(0, 0, indexCount, 1);
        }
    }

    public static void buildSkyHalf(class_4588 vertexConsumer, float y, boolean bottom) {
        int width = 64;
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float g = k;
                float h = k + 64;
                if (bottom) {
                    float b = g;
                    g = h;
                    h = b;
                }
                vertexConsumer.method_22912(g, y, (float)l);
                vertexConsumer.method_22912(h, y, (float)l);
                vertexConsumer.method_22912(h, y, (float)(l + 64));
                vertexConsumer.method_22912(g, y, (float)(l + 64));
            }
        }
    }

    public static GpuBuffer getBlueVoidBuffer() {
        return animatium$blueVoidBuffer;
    }

    public static void initializeBlueVoidSky() {
        animatium$blueVoidBuffer = RenderUtils.initializeSky(builder -> RenderUtils.buildSkyHalf((class_4588)builder, -16.0f, true));
    }

    public static GpuBuffer initializeSky(Consumer<class_287> bufferBuilderConsumer) {
        GpuBuffer gpuBuffer;
        block8: {
            VertexFormat.class_5596 mode = VertexFormat.class_5596.field_27382;
            class_287 builder = class_289.method_1348().method_60827(mode, class_290.field_1592);
            bufferBuilderConsumer.accept(builder);
            class_9801 meshData = builder.method_60800();
            try {
                gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Static sky vertex buffer", 8, meshData.method_60818());
                if (meshData == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (meshData != null) {
                        try {
                            meshData.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            meshData.close();
        }
        return gpuBuffer;
    }

    public static void renderBlueVoidSky(class_310 minecraft, int skyColor, double depth) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.translate(0.0f, -((float)(depth - 16.0)), 0.0f);
        Vector3f skyColorVec = class_9848.method_64963((int)skyColor);
        GpuBufferSlice transforms = DynamicTransformsBuilder.of().withShaderColor(new Vector3f(skyColorVec.x * 0.2f + 0.04f, skyColorVec.y * 0.2f + 0.04f, skyColorVec.z * 0.6f + 0.1f)).build();
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Blue void disc", minecraft.method_1522().method_71639(), OptionalInt.empty(), minecraft.method_1522().method_71640(), OptionalDouble.empty());){
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            renderPass.setPipeline(AnimatiumConfig.instance().planarSkyFog ? AnimatiumClient.LEGACY_SKY_PLANAR_FOG_PIPELINE : AnimatiumClient.LEGACY_SKY_PIPELINE);
            renderPass.setVertexBuffer(0, animatium$blueVoidBuffer);
            renderPass.setIndexBuffer(autoStorageIndexBuffer.method_68274(6), autoStorageIndexBuffer.method_31924());
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", transforms);
            renderPass.drawIndexed(0, 0, 1014, 1);
        }
        modelViewStack.popMatrix();
    }
}

