/*
 * Decompiled with CFR 0.152.
 */
package btw.mixces.animatium.util;

import btw.mixces.animatium.util.RenderUtils;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class DynamicTransformsBuilder {
    private Optional<Matrix4f> modelViewMatrix = Optional.empty();
    private Optional<Vector4f> colorModulator = Optional.empty();
    private Optional<Vector3f> modelOffset = Optional.empty();
    private Optional<Matrix4f> textureMatrix = Optional.empty();
    private Optional<Float> lineWidth = Optional.empty();

    public static DynamicTransformsBuilder of() {
        return new DynamicTransformsBuilder();
    }

    public DynamicTransformsBuilder withModelViewMatrix(Matrix4f matrix4f) {
        this.modelViewMatrix = Optional.of(matrix4f);
        return this;
    }

    public DynamicTransformsBuilder withShaderColor(Vector4f vector4f) {
        this.colorModulator = Optional.of(vector4f);
        return this;
    }

    public DynamicTransformsBuilder withShaderColor(Vector3f vector3f) {
        return this.withShaderColor(new Vector4f((Vector3fc)vector3f, 1.0f));
    }

    public DynamicTransformsBuilder withModelOffset(Vector3f vector3f) {
        this.modelOffset = Optional.of(vector3f);
        return this;
    }

    public DynamicTransformsBuilder withTextureMatrix(Matrix4f matrix4f) {
        this.textureMatrix = Optional.of(matrix4f);
        return this;
    }

    public DynamicTransformsBuilder withLineWidth(float lineWidth) {
        this.lineWidth = Optional.of(Float.valueOf(lineWidth));
        return this;
    }

    public GpuBufferSlice build() {
        return RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)this.modelViewMatrix.orElse(RenderSystem.getModelViewMatrix()), (Vector4fc)this.colorModulator.orElse(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f)), (Vector3fc)this.modelOffset.orElse(RenderSystem.getModelOffset()), (Matrix4fc)this.textureMatrix.orElse(RenderSystem.getTextureMatrix()), this.lineWidth.orElse(Float.valueOf(RenderUtils.getLineWidth(Float.valueOf(RenderSystem.getShaderLineWidth())))).floatValue());
    }
}

